/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.ItemInfoBuilder;
import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageIRecipe;
import de.maxanier.guideapi.page.PageJsonRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookHelper {
    private final Logger LOGGER;
    private final String modid;
    private final String baseKey;
    private final Function<Recipe<?>, IRecipeRenderer> recipeRendererSupplier;
    private final BiFunction<String, Object[], Component> localizer;
    private final Function<Block, String> blockNameMapper;
    private final Function<Item, String> itemNameMapper;
    private final Map<ResourceLocation, EntryAbstract> links = Maps.newHashMap();

    private BookHelper(String modid, String baseKey, Function<Recipe<?>, IRecipeRenderer> recipeRendererSupplier, BiFunction<String, Object[], Component> localizer, Function<Block, String> blockNameMapper, Function<Item, String> itemNameMapper) {
        this.LOGGER = LogManager.getLogger((String)("BookHelper_" + modid));
        this.modid = modid;
        this.baseKey = baseKey;
        this.recipeRendererSupplier = recipeRendererSupplier;
        this.localizer = localizer;
        this.blockNameMapper = blockNameMapper;
        this.itemNameMapper = itemNameMapper;
    }

    public List<IPage> addLinks(List<IPage> pages, Object ... links) {
        ArrayList linkPages = Lists.newArrayList();
        for (IPage p : pages) {
            linkPages.add(new PageHolderWithLinks(this, p));
        }
        for (Object l : links) {
            if (l instanceof ResourceLocation) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((ResourceLocation)l);
                }
                continue;
            }
            if (l instanceof EntryAbstract) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((EntryAbstract)l);
                }
                continue;
            }
            if (l instanceof PageHolderWithLinks.URLLink) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((PageHolderWithLinks.URLLink)l);
                }
                continue;
            }
            this.LOGGER.warn("Given link object cannot be linked {}", l);
        }
        pages.clear();
        pages.addAll(linkPages);
        return pages;
    }

    @Nullable
    public BrewingRecipe getBrewingRecipe(ItemStack stack) {
        return BrewingRecipeRegistry.getRecipes().stream().filter(iBrewingRecipe -> iBrewingRecipe instanceof BrewingRecipe && ItemStack.m_41728_((ItemStack)((BrewingRecipe)iBrewingRecipe).getOutput(), (ItemStack)stack)).findFirst().orElse(null);
    }

    @Nullable
    public EntryAbstract getLinkedEntry(ResourceLocation location) {
        return this.links.get(location);
    }

    public IPage getRecipePage(ResourceLocation id) {
        return new PageJsonRecipe(id, this.recipeRendererSupplier);
    }

    public ItemInfoBuilder info(boolean block, Ingredient ingredient, ItemStack mainStack) {
        Item item = mainStack.m_41720_();
        String name = item instanceof BlockItem ? this.blockNameMapper.apply(((BlockItem)item).m_40614_()) : this.itemNameMapper.apply(item);
        return new ItemInfoBuilder(this, ingredient, mainStack, name, block);
    }

    public ItemInfoBuilder info(Item ... items) {
        assert (items.length > 0);
        Item i0 = items[0];
        String name = this.itemNameMapper.apply(i0);
        return new ItemInfoBuilder(this, Ingredient.m_43929_((ItemLike[])items), new ItemStack((ItemLike)i0), name, false);
    }

    public ItemInfoBuilder info(boolean block, ItemStack ... stacks) {
        assert (stacks.length > 0);
        ItemStack i0 = stacks[0];
        Item item = i0.m_41720_();
        String name = item instanceof BlockItem ? this.blockNameMapper.apply(((BlockItem)item).m_40614_()) : this.itemNameMapper.apply(item);
        return new ItemInfoBuilder(this, Ingredient.m_43927_((ItemStack[])stacks), i0, name, block);
    }

    public ItemInfoBuilder info(Block ... blocks) {
        assert (blocks.length > 0);
        Block i0 = blocks[0];
        String name = this.blockNameMapper.apply(i0);
        return new ItemInfoBuilder(this, Ingredient.m_43929_((ItemLike[])blocks), new ItemStack((ItemLike)i0), name, true);
    }

    public Component localize(String key, Object ... formats) {
        return this.localizer.apply(key, formats);
    }

    public void registerLinkablePages(List<CategoryAbstract> categories) {
        for (CategoryAbstract c : categories) {
            this.links.putAll(c.entries);
        }
    }

    protected String getBaseKey() {
        return this.baseKey;
    }

    protected String getModid() {
        return this.modid;
    }

    public static class Builder {
        private final String modid;
        private String baseKey;
        private Function<Recipe<?>, IRecipeRenderer> recipeRendererSupplier = PageIRecipe::getRenderer;
        private BiFunction<String, Object[], Component> localizer = Component::m_237110_;
        private Function<Block, String> blockNameMapper = block -> ForgeRegistries.BLOCKS.getKey(block).m_135815_();
        private Function<Item, String> itemNameMapper = item -> ForgeRegistries.ITEMS.getKey(item).m_135815_();

        public Builder(String modid) {
            this.modid = modid;
            this.baseKey = "guide." + modid;
        }

        public BookHelper build() {
            return new BookHelper(this.modid, this.baseKey, this.recipeRendererSupplier, this.localizer, this.blockNameMapper, this.itemNameMapper);
        }

        public Builder setBaseKey(String baseKey) {
            this.baseKey = baseKey;
            return this;
        }

        public Builder setBlockNameMapper(Function<Block, String> blockNameMapper) {
            this.blockNameMapper = blockNameMapper;
            return this;
        }

        public Builder setItemNameMapper(Function<Item, String> itemNameMapper) {
            this.itemNameMapper = itemNameMapper;
            return this;
        }

        public Builder setLocalizer(BiFunction<String, Object[], Component> localizer) {
            this.localizer = localizer;
            return this;
        }

        public Builder setRecipeRendererSupplier(Function<Recipe<?>, IRecipeRenderer> rendererSupplier) {
            this.recipeRendererSupplier = rendererSupplier;
            return this;
        }
    }
}

