/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.category;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Category;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CategoryResourceLocation
extends Category {
    public ResourceLocation resourceLocation;

    public CategoryResourceLocation(Map<ResourceLocation, EntryAbstract> entries, Component name, ResourceLocation resourceLocation) {
        super(entries, name);
        this.resourceLocation = resourceLocation;
    }

    public CategoryResourceLocation(Component name, ResourceLocation resourceLocation) {
        super(name);
        this.resourceLocation = resourceLocation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
        GuiHelper.drawSizedIconWithoutColor(graphics, categoryX, categoryY, 48, 48, 0.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft) {
        if (this.canSee(guiBase.player, guiBase.bookStack) && GuiHelper.isMouseBetween(mouseX, mouseY, categoryX, categoryY, categoryWidth, categoryHeight)) {
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, this.getTooltip(), mouseX, mouseY);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryResourceLocation)) {
            return false;
        }
        CategoryResourceLocation that = (CategoryResourceLocation)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.resourceLocation, that.resourceLocation);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.resourceLocation != null ? this.resourceLocation.hashCode() : 0);
        return result;
    }
}

