/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageText;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageTextImage
extends Page {
    public PageText pageText;
    public ResourceLocation image;
    public boolean drawAtTop;

    public PageTextImage(FormattedText draw, ResourceLocation image, boolean drawAtTop) {
        this.pageText = new PageText(draw, drawAtTop ? 0 : 100);
        this.image = image;
        this.drawAtTop = drawAtTop;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.image);
        GuiHelper.drawSizedIconWithoutColor(graphics, guiLeft + 60, guiTop + (this.drawAtTop ? 60 : 12), guiBase.xSize, guiBase.ySize, 0.0f);
        this.pageText.draw(graphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageTextImage)) {
            return false;
        }
        PageTextImage that = (PageTextImage)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.drawAtTop != that.drawAtTop) {
            return false;
        }
        if (!Objects.equals(this.pageText, that.pageText)) {
            return false;
        }
        return Objects.equals(this.image, that.image);
    }

    public int hashCode() {
        int result = this.pageText != null ? this.pageText.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.drawAtTop ? 1 : 0);
        return result;
    }
}

