/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.util.AnnotationHandler;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="guideapi_vp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrarGuideAPIClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            event.register((ResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void bakeModel(ModelEvent.ModifyBakingResult event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            ModelResourceLocation newMrl = new ModelResourceLocation(loc, "inventory");
            Item bookItem = GuideAPI.getStackFromBook((Book)guide.getLeft()).m_41720_();
            ModelResourceLocation oldMrl = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)bookItem), "inventory");
            BakedModel model = (BakedModel)event.getModels().get(newMrl);
            event.getModels().put(oldMrl, model);
        }
    }
}

