/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl.abstraction;

import com.google.common.collect.Lists;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntryAbstract {
    public final List<IPage> pageList;
    public final Component name;

    public EntryAbstract(List<IPage> pageList, Component name) {
        this.pageList = pageList;
        this.name = name;
    }

    public EntryAbstract(Component name) {
        this(Lists.newArrayList(), name);
    }

    public void addPage(IPage page) {
        this.pageList.add(page);
    }

    public void addPageList(List<IPage> pages) {
        this.pageList.addAll(pages);
    }

    public abstract boolean canSee(Player var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void draw(GuiGraphics var1, RegistryAccess var2, Book var3, CategoryAbstract var4, int var5, int var6, int var7, int var8, int var9, int var10, BaseScreen var11, Font var12);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawExtras(GuiGraphics var1, Book var2, CategoryAbstract var3, int var4, int var5, int var6, int var7, int var8, int var9, BaseScreen var10, Font var11);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryAbstract that = (EntryAbstract)o;
        if (!Objects.equals(this.pageList, that.pageList)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public Component getName() {
        return this.name;
    }

    public int hashCode() {
        int result = this.pageList != null ? this.pageList.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onInit(Book var1, CategoryAbstract var2, CategoryScreen var3, Player var4, ItemStack var5);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onLeftClicked(Book var1, CategoryAbstract var2, double var3, double var5, Player var7, CategoryScreen var8);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onRightClicked(Book var1, CategoryAbstract var2, double var3, double var5, Player var7, CategoryScreen var8);

    public void removePage(IPage page) {
        this.pageList.remove(page);
    }

    public void removePageList(List<IPage> pages) {
        this.pageList.removeAll(pages);
    }
}

