/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class GuiHelper {
    private static final ItemRenderer render = Minecraft.m_91087_().m_91291_();

    public static boolean isMouseBetween(double mouseX, double mouseY, int x, int y, int width, int height) {
        int xSize = x + width;
        int ySize = y + height;
        return mouseX >= (double)x && mouseX <= (double)xSize && mouseY >= (double)y && mouseY <= (double)ySize;
    }

    public static void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        PoseStack mStack = RenderSystem.getModelViewStack();
        mStack.m_85836_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, x, y, null);
        mStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawScaledItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, float scale) {
        PoseStack mStack = RenderSystem.getModelViewStack();
        mStack.m_85836_();
        mStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        RenderSystem.applyModelViewMatrix();
        graphics.m_280480_(stack, (int)((float)x / scale), (int)((float)y / scale));
        mStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawSizedIconWithoutColor(GuiGraphics graphics, int x, int y, int width, int height, float zLevel) {
        PoseStack mStack = RenderSystem.getModelViewStack();
        mStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mStack.m_85841_(0.5f, 0.5f, 0.5f);
        mStack.m_252880_((float)x, (float)y, zLevel);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        Tesselator tessellator = Tesselator.m_85913_();
        tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        tessellator.m_85915_().m_5483_((double)x, (double)(y + height), (double)zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)(x + width), (double)y, (double)zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)x, (double)y, (double)zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        mStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawSizedIconWithColor(GuiGraphics graphics, int x, int y, int width, int height, float zLevel, Color color) {
        PoseStack mStack = RenderSystem.getModelViewStack();
        mStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        mStack.m_85841_(0.5f, 0.5f, 0.5f);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        mStack.m_252880_((float)x, (float)y, zLevel);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        Tesselator tessellator = Tesselator.m_85913_();
        tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        tessellator.m_85915_().m_5483_((double)x, (double)(y + height), (double)zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)(x + width), (double)y, (double)zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85915_().m_5483_((double)x, (double)y, (double)zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        mStack.m_85836_();
        RenderSystem.applyModelViewMatrix();
    }

    public static List<Component> getTooltip(ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        List list = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        for (int k = 0; k < list.size(); ++k) {
            Component c = (Component)list.get(k);
            if (!(c instanceof MutableComponent)) continue;
            if (k == 0) {
                ((MutableComponent)c).m_130940_(stack.m_41791_().f_43022_);
                continue;
            }
            ((MutableComponent)c).m_130940_(ChatFormatting.GRAY);
        }
        return list;
    }
}

