/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.network;

import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.util.NBTBookTags;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncEntry {
    public int category;
    public ResourceLocation entry;
    public int page;

    static void encode(PacketSyncEntry msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.category);
        buf.m_130085_(msg.entry);
        buf.writeInt(msg.page);
    }

    static PacketSyncEntry decode(FriendlyByteBuf buf) {
        PacketSyncEntry msg = new PacketSyncEntry();
        msg.category = buf.readInt();
        msg.entry = buf.m_130281_();
        msg.page = buf.readInt();
        return msg;
    }

    public static void handle(PacketSyncEntry msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            ItemStack book = player.m_21206_();
            if (book.m_41619_() || !(book.m_41720_() instanceof IGuideItem)) {
                book = player.m_21205_();
            }
            if (!book.m_41619_() && book.m_41720_() instanceof IGuideItem && msg.category != -1 && !msg.entry.equals((Object)new ResourceLocation("guideapi_vp", "none")) && msg.page != -1) {
                if (!book.m_41782_()) {
                    book.m_41751_(new CompoundTag());
                }
                book.m_41783_().m_128405_(NBTBookTags.CATEGORY_TAG, msg.category);
                book.m_41783_().m_128359_(NBTBookTags.ENTRY_TAG, msg.entry.toString());
                book.m_41783_().m_128405_(NBTBookTags.PAGE_TAG, msg.page);
            }
        });
        ctx.setPacketHandled(true);
    }

    public PacketSyncEntry() {
        this.category = -1;
        this.entry = new ResourceLocation("guideapi_vp", "none");
        this.page = -1;
    }

    public PacketSyncEntry(int category, ResourceLocation entry, int page) {
        this.category = category;
        this.entry = entry;
        this.page = page;
    }
}

