/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.proxy;

import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.NBTBookTags;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.proxy.CommonProxy;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClientProxy
extends CommonProxy {
    @Override
    public void initColors() {
        for (Supplier<ItemStack> bookStack : GuideAPI.getBookToStack().values()) {
            Minecraft.m_91087_().getItemColors().m_92689_((stack, tintIndex) -> {
                IGuideItem guideItem = (IGuideItem)stack.m_41720_();
                if (guideItem.getBook(stack) != null && tintIndex == 0) {
                    return guideItem.getBook(stack).getColor().getRGB();
                }
                return -1;
            }, new ItemLike[]{bookStack.get().m_41720_()});
        }
    }

    @Override
    public void openEntry(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, Player player, ItemStack stack) {
        BookEvent.Open event = new BookEvent.Open(book, stack, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            player.m_5661_(event.getCanceledText(), true);
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new EntryScreen(book, categoryAbstract, entryAbstract, player, stack));
    }

    @Override
    public void openGuidebook(Player player, Level world, Book book, ItemStack bookStack) {
        if (!bookStack.m_41619_() && bookStack.m_41720_() instanceof IGuideItem) {
            book.initializeContent();
            try {
                if (bookStack.m_41782_()) {
                    CompoundTag tagCompound = bookStack.m_41783_();
                    if (tagCompound.m_128441_(NBTBookTags.ENTRY_TAG) && tagCompound.m_128441_(NBTBookTags.CATEGORY_TAG)) {
                        CategoryAbstract category = book.getCategoryList().get(tagCompound.m_128451_(NBTBookTags.CATEGORY_TAG));
                        EntryAbstract entry = category.entries.get(new ResourceLocation(tagCompound.m_128461_(NBTBookTags.ENTRY_TAG)));
                        int pageNumber = tagCompound.m_128451_(NBTBookTags.PAGE_TAG);
                        EntryScreen guiEntry = new EntryScreen(book, category, entry, player, bookStack);
                        guiEntry.pageNumber = pageNumber;
                        Minecraft.m_91087_().m_91152_((Screen)guiEntry);
                        return;
                    }
                    if (tagCompound.m_128441_(NBTBookTags.CATEGORY_TAG)) {
                        CategoryAbstract category = book.getCategoryList().get(tagCompound.m_128451_(NBTBookTags.CATEGORY_TAG));
                        int entryPage = tagCompound.m_128451_(NBTBookTags.ENTRY_PAGE_TAG);
                        CategoryScreen guiCategory = new CategoryScreen(book, category, player, bookStack, null);
                        guiCategory.entryPage = entryPage;
                        Minecraft.m_91087_().m_91152_((Screen)guiCategory);
                        return;
                    }
                    int categoryNumber = tagCompound.m_128451_(NBTBookTags.CATEGORY_PAGE_TAG);
                    HomeScreen guiHome = new HomeScreen(book, player, bookStack);
                    guiHome.categoryPage = categoryNumber;
                    Minecraft.m_91087_().m_91152_((Screen)guiHome);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Minecraft.m_91087_().m_91152_((Screen)new HomeScreen(book, player, bookStack));
        }
    }

    @Override
    public void playSound(SoundEvent sound) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }
}

