/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.counter;

import earth.terrarium.handcrafted.common.block.ItemHoldingBlockEntity;
import earth.terrarium.handcrafted.common.block.counter.CounterBlockEntity;
import earth.terrarium.handcrafted.common.block.counter.ShelfBlock;
import earth.terrarium.handcrafted.common.block.property.DirectionalBlockSide;
import earth.terrarium.handcrafted.common.item.Hammerable;
import earth.terrarium.handcrafted.common.registry.ModTags;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class CounterBlock
extends ShelfBlock
implements Hammerable {
    public static final EnumProperty<DirectionalBlockSide> COUNTER_SHAPE = EnumProperty.m_61587_((String)"shape", DirectionalBlockSide.class);

    public CounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(COUNTER_SHAPE, (Comparable)((Object)DirectionalBlockSide.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !(newState.m_60734_() instanceof CounterBlock)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ItemHoldingBlockEntity) {
                ItemHoldingBlockEntity entity = (ItemHoldingBlockEntity)blockEntity;
                if (entity.getStack().m_41720_() != Items.f_151047_) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.getStack());
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.5));
                    level.m_7967_((Entity)itemEntity);
                    level.m_46717_(pos, (Block)this);
                }
                entity.clear();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CounterBlockEntity(pos, state);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SoundEvent event = player.m_21205_().m_204117_(ItemTags.f_13168_) ? SoundEvents.f_12635_ : SoundEvents.f_12447_;
        return ItemHoldingBlockEntity.placeItem(level, pos, player, Items.f_151047_.m_7968_(), f -> f.m_204117_(ModTags.COUNTER_SURFACE), event);
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        Block block = state.m_60734_();
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        Block replacement = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().replaceAll("\\d+", String.valueOf(Integer.parseInt(id.m_135815_().replaceAll("\\D+", "")) + 1))));
        ItemStack item = ((ItemHoldingBlockEntity)level.m_7702_(pos)).getStack();
        if (replacement.equals(Blocks.f_50016_)) {
            level.m_7731_(pos, (BlockState)((BlockState)((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().replaceAll("\\d+", "1")))).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(COUNTER_SHAPE, (Comparable)((Object)((DirectionalBlockSide)((Object)state.m_61143_(COUNTER_SHAPE))))), 3);
        } else {
            level.m_7731_(pos, (BlockState)((BlockState)replacement.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(COUNTER_SHAPE, (Comparable)((Object)((DirectionalBlockSide)((Object)state.m_61143_(COUNTER_SHAPE))))), 3);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ItemHoldingBlockEntity) {
            ItemHoldingBlockEntity entity = (ItemHoldingBlockEntity)blockEntity;
            entity.setStack(item);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        return ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().substring(0, id.m_135815_().length() - 2)))).m_7968_();
    }
}

