/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.datagen.provider.server;

import earth.terrarium.handcrafted.common.registry.ModItems;
import earth.terrarium.handcrafted.common.registry.ModTags;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        ModRecipeProvider.createColouredSetRecipe(consumer, "cushion", 8, r -> r.m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42402_).m_126130_("###").m_126130_("///").m_126130_("###"));
        ModRecipeProvider.createColouredSetRecipe(consumer, "sheet", 8, r -> r.m_126130_("   ").m_126130_("###").m_126130_("   "));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BLACK_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42498_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BLUE_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42494_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BROWN_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42495_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.CYAN_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42492_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.GRAY_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42490_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.GREEN_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42496_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIGHT_BLUE_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42538_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIGHT_GRAY_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42491_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIME_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42540_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.MAGENTA_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42537_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.ORANGE_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42536_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.PINK_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42489_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.PURPLE_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42493_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.RED_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42497_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.WHITE_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42535_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.YELLOW_CUSHION.get(), 1, r -> r.m_126132_("has_cushion", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.CUSHIONS)).m_206419_(ModTags.CUSHIONS).m_126209_((ItemLike)Items.f_42539_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BLACK_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42498_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BLUE_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42494_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.BROWN_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42495_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.CYAN_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42492_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.GRAY_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42490_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.GREEN_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42496_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIGHT_BLUE_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42538_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIGHT_GRAY_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42491_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.LIME_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42540_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.MAGENTA_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42537_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.ORANGE_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42536_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.PINK_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42489_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.PURPLE_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42493_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.RED_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42497_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.WHITE_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42535_));
        ModRecipeProvider.createSingleDyeShapeless(consumer, (Item)ModItems.YELLOW_SHEET.get(), 1, r -> r.m_126132_("has_sheet", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.SHEETS)).m_206419_(ModTags.SHEETS).m_126209_((ItemLike)Items.f_42539_));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.HAMMER.get(), 1, r -> r.m_126132_("has_board", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.BOARDS)).m_206416_(Character.valueOf('#'), ModTags.BOARDS).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42416_).m_126130_(" / ").m_126130_(" #/").m_126130_("#  "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.STACKABLE_BOOK.get(), 3, r -> r.m_126132_("has_book", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42517_).m_126130_(" # ").m_126130_(" # ").m_126130_(" # "));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.FANCY_PAINTING.get(), 1, r -> r.m_126132_("has_painting", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42487_)).m_126209_((ItemLike)Items.f_42487_).m_126209_((ItemLike)Items.f_42417_));
        ModRecipeProvider.createWoodSetRecipe(consumer, "chair", 2, r -> r.m_126130_("#  ").m_126130_("###").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "table", 2, r -> r.m_126130_("###").m_126130_("# #").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "bench", 3, r -> r.m_126130_("###").m_126130_("###").m_126130_("# #"));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.BENCH.get(), 1, r -> r.m_126132_("has_iron_ingot", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42025_).m_126130_("/#/").m_126130_("/#/").m_126130_("/ /"));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.FROZEN_BENCH.get(), 1, r -> r.m_126132_("has_iron_ingot", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42416_)).m_126127_(Character.valueOf('#'), (ItemLike)ModItems.BENCH.get()).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42452_).m_126130_("///").m_126130_(" # ").m_126130_("   "));
        ModRecipeProvider.createWoodSetRecipe(consumer, "couch", 3, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)ModItems.WHITE_CUSHION.get()).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_41870_).m_126130_(" @ ").m_126130_("#/#").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "fancy_bed", 1, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)ModItems.WHITE_CUSHION.get()).m_126127_(Character.valueOf('$'), (ItemLike)ModItems.WHITE_SHEET.get()).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_41870_).m_126130_("@$ ").m_126130_("///").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "dining_bench", 3, r -> r.m_126130_("   ").m_126130_("###").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipeWithPlanks(consumer, "nightstand", 2, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42009_).m_126130_("///").m_126130_("#@#").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipeWithPlanks(consumer, "desk", 2, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42009_).m_126130_("///").m_126130_("#@#").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipeWithPlanks(consumer, "side_table", 2, r -> r.m_126130_("   ").m_126130_("#/#").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "counter", 2, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42009_).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_151047_).m_126130_("///").m_126130_("#@#").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "drawer", 2, r -> r.m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42009_).m_126130_("###").m_126130_("#/#").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipeWithPlanks(consumer, "cupboard", 2, r -> r.m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42009_).m_126130_("###").m_126130_("/@/").m_126130_("###"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "shelf", 2, r -> r.m_126130_("###").m_126130_("   ").m_126130_("###"));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.OVEN.get(), 1, r -> r.m_126132_("has_smoker", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42769_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('/'), (ItemLike)Items.f_42025_).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42769_).m_126130_("#/#").m_126130_("#@#").m_126130_("###"));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.KITCHEN_HOOD.get(), 1, r -> r.m_126132_("has_oven", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.OVEN.get()))).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42025_).m_126127_(Character.valueOf('/'), (ItemLike)ModItems.KITCHEN_HOOD_PIPE.get()).m_126130_(" / ").m_126130_("###").m_126130_("   "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.KITCHEN_HOOD_PIPE.get(), 1, r -> r.m_126132_("has_oven", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.OVEN.get()))).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42025_).m_126130_("# #").m_126130_("# #").m_126130_("# #"));
        ModRecipeProvider.createWoodSetRecipe(consumer, "pillar_trim", 4, r -> r.m_126130_(" # ").m_126130_(" # ").m_126130_(" # "));
        ModRecipeProvider.createWoodSetRecipe(consumer, "corner_trim", 4, r -> r.m_126130_("###").m_126130_("  #").m_126130_("  #"));
        ModRecipeProvider.createTrim(consumer, "pillar_trim", 4, r -> r.m_126130_(" # ").m_126130_(" # ").m_126130_(" # "));
        ModRecipeProvider.createTrim(consumer, "corner_trim", 4, r -> r.m_126130_("###").m_126130_("  #").m_126130_("  #"));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BERRY_JAM_JAR.get(), 1, r -> r.m_126132_("has_sweet_berries", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42780_)).m_126209_((ItemLike)Items.f_42780_).m_126209_((ItemLike)Items.f_42590_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_CUP.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_CUP.get()).m_126209_((ItemLike)Items.f_42535_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.YELLOW_CUP.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_CUP.get()).m_126209_((ItemLike)Items.f_42539_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_CUP.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_CUP.get()).m_126209_((ItemLike)Items.f_42494_));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.WOOD_CUP.get(), 3, r -> r.m_126132_("has_board", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.BOARDS)).m_206416_(Character.valueOf('#'), ModTags.BOARDS).m_126130_("   ").m_126130_(" # ").m_126130_(" # "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_CUP.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("   ").m_126130_(" # ").m_126130_(" # "));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_PLATE.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_PLATE.get()).m_126209_((ItemLike)Items.f_42535_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.YELLOW_PLATE.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_PLATE.get()).m_126209_((ItemLike)Items.f_42539_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_PLATE.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_PLATE.get()).m_126209_((ItemLike)Items.f_42494_));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.WOOD_PLATE.get(), 3, r -> r.m_126132_("has_board", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.BOARDS)).m_206416_(Character.valueOf('#'), ModTags.BOARDS).m_126130_("   ").m_126130_("###").m_126130_("   "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_PLATE.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("   ").m_126130_("###").m_126130_("   "));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_BOWL.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_BOWL.get()).m_126209_((ItemLike)Items.f_42535_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.YELLOW_BOWL.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_BOWL.get()).m_126209_((ItemLike)Items.f_42539_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_BOWL.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_BOWL.get()).m_126209_((ItemLike)Items.f_42494_));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.WOOD_BOWL.get(), 3, r -> r.m_126132_("has_board", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.BOARDS)).m_206416_(Character.valueOf('#'), ModTags.BOARDS).m_126130_("# #").m_126130_(" # ").m_126130_("   "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_BOWL.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("# #").m_126130_(" # ").m_126130_("   "));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_CROCKERY_COMBO.get(), 1, r -> r.m_126132_("has_terracotta=_plate", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_PLATE.get()))).m_126132_("has_terracotta_bowl", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_BOWL.get()))).m_126209_((ItemLike)ModItems.WHITE_CUP.get()).m_126209_((ItemLike)ModItems.WHITE_PLATE.get()));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.YELLOW_CROCKERY_COMBO.get(), 1, r -> r.m_126132_("has_terracotta=_plate", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_PLATE.get()))).m_126132_("has_terracotta_bowl", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_BOWL.get()))).m_126209_((ItemLike)ModItems.YELLOW_CUP.get()).m_126209_((ItemLike)ModItems.YELLOW_PLATE.get()));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_CROCKERY_COMBO.get(), 1, r -> r.m_126132_("has_terracotta=_plate", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_PLATE.get()))).m_126132_("has_terracotta_bowl", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_BOWL.get()))).m_126209_((ItemLike)ModItems.BLUE_CUP.get()).m_126209_((ItemLike)ModItems.BLUE_PLATE.get()));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WOOD_CROCKERY_COMBO.get(), 1, r -> r.m_126132_("has_terracotta=_plate", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_PLATE.get()))).m_126132_("has_terracotta_bowl", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_BOWL.get()))).m_126209_((ItemLike)ModItems.WOOD_CUP.get()).m_126209_((ItemLike)ModItems.WOOD_PLATE.get()));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.TERRACOTTA_CROCKERY_COMBO.get(), 1, r -> r.m_126132_("has_terracotta=_plate", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_PLATE.get()))).m_126132_("has_terracotta_bowl", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.TERRACOTTA_BOWL.get()))).m_126209_((ItemLike)ModItems.TERRACOTTA_CUP.get()).m_126209_((ItemLike)ModItems.TERRACOTTA_PLATE.get()));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_THIN_POT.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("## ").m_126130_("## ").m_126130_("   "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_MEDIUM_POT.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("## ").m_126130_("## ").m_126130_("## "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_WIDE_POT.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("# #").m_126130_("# #").m_126130_(" # "));
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.TERRACOTTA_THICK_POT.get(), 3, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42199_).m_126130_("# #").m_126130_("# #").m_126130_("###"));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_GLAZED_THIN_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THIN_POT.get()).m_126209_((ItemLike)Items.f_42230_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_GLAZED_MEDIUM_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_MEDIUM_POT.get()).m_126209_((ItemLike)Items.f_42230_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_GLAZED_WIDE_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_WIDE_POT.get()).m_126209_((ItemLike)Items.f_42230_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.WHITE_GLAZED_THICK_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THICK_POT.get()).m_126209_((ItemLike)Items.f_42230_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_GLAZED_THIN_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THIN_POT.get()).m_126209_((ItemLike)Items.f_42241_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_GLAZED_MEDIUM_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_MEDIUM_POT.get()).m_126209_((ItemLike)Items.f_42241_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_GLAZED_WIDE_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_WIDE_POT.get()).m_126209_((ItemLike)Items.f_42241_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.BLUE_GLAZED_THICK_POT.get(), 1, r -> r.m_126132_("has_terracotta", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42199_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THICK_POT.get()).m_126209_((ItemLike)Items.f_42241_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.GOLDEN_THIN_POT.get(), 1, r -> r.m_126132_("has_gold_block", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_41912_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THIN_POT.get()).m_126209_((ItemLike)Items.f_41912_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.GOLDEN_MEDIUM_POT.get(), 1, r -> r.m_126132_("has_gold_block", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_41912_)).m_126209_((ItemLike)ModItems.TERRACOTTA_MEDIUM_POT.get()).m_126209_((ItemLike)Items.f_41912_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.GOLDEN_WIDE_POT.get(), 1, r -> r.m_126132_("has_gold_block", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_41912_)).m_126209_((ItemLike)ModItems.TERRACOTTA_WIDE_POT.get()).m_126209_((ItemLike)Items.f_41912_));
        ModRecipeProvider.createSimpleShapeless(consumer, (Item)ModItems.GOLDEN_THICK_POT.get(), 1, r -> r.m_126132_("has_gold_block", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_41912_)).m_126209_((ItemLike)ModItems.TERRACOTTA_THICK_POT.get()).m_126209_((ItemLike)Items.f_41912_));
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.BEAR_TROPHY.get(), 1, Items.f_42526_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.BLAZE_TROPHY.get(), 1, Items.f_42585_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.FOX_TROPHY.get(), 1, Items.f_42780_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.GOAT_TROPHY.get(), 1, Items.f_220219_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.PUFFERFISH_TROPHY.get(), 1, Items.f_42529_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.SALMON_TROPHY.get(), 1, Items.f_42527_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.SILVERFISH_TROPHY.get(), 1, Items.f_42021_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.SKELETON_HORSE_TROPHY.get(), 1, Items.f_42450_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.SPIDER_TROPHY.get(), 1, Items.f_42591_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.TROPICAL_FISH_TROPHY.get(), 1, Items.f_42528_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.WITHER_SKELETON_TROPHY.get(), 1, Items.f_42679_);
        ModRecipeProvider.createWallTrophy(consumer, (Item)ModItems.WOLF_TROPHY.get(), 1, Items.f_42500_);
        ModRecipeProvider.createSimple(consumer, (Item)ModItems.PHANTOM_TROPHY.get(), 1, r -> r.m_126132_("has_phantom_membrane", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42714_)).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42714_).m_206416_(Character.valueOf('/'), ModTags.BOARDS).m_126127_(Character.valueOf('@'), (ItemLike)Items.f_42026_).m_126130_("@@@").m_126130_("/#/").m_126130_("   "));
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.CREEPER_TROPHY.get(), 1, Items.f_42682_);
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.SKELETON_TROPHY.get(), 1, Items.f_42678_);
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.EVOKER_TROPHY.get(), 1, Items.f_42747_);
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.PILLAGER_TROPHY.get(), 1, Items.f_42717_);
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.VINDICATOR_TROPHY.get(), 1, Items.f_42386_);
        ModRecipeProvider.createStatueTrophy(consumer, (Item)ModItems.WITCH_TROPHY.get(), 1, Items.f_42590_);
    }

    public static void createSimple(Consumer<FinishedRecipe> consumer, Item output, int count, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> func) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output)).m_135815_();
        func.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count)).m_126145_(name).m_176498_(consumer);
    }

    public static void createSimpleShapeless(Consumer<FinishedRecipe> consumer, Item output, int count, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> func) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output)).m_135815_();
        func.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count)).m_126145_(name).m_176498_(consumer);
    }

    public static void createSingleDyeShapeless(Consumer<FinishedRecipe> consumer, Item output, int count, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> func) {
        String name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output)).m_135815_();
        func.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count)).m_126145_(name).m_126140_(consumer, new ResourceLocation("handcrafted", name + "_single"));
    }

    public static void createWoodSetRecipe(Consumer<FinishedRecipe> consumer, String suffix, int count, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> func) {
        for (Item wood : new Item[]{(Item)ModItems.ACACIA_BOARD.get(), (Item)ModItems.BIRCH_BOARD.get(), (Item)ModItems.DARK_OAK_BOARD.get(), (Item)ModItems.JUNGLE_BOARD.get(), (Item)ModItems.MANGROVE_BOARD.get(), (Item)ModItems.OAK_BOARD.get(), (Item)ModItems.SPRUCE_BOARD.get(), (Item)ModItems.CRIMSON_BOARD.get(), (Item)ModItems.WARPED_BOARD.get(), (Item)ModItems.CHERRY_BOARD.get(), (Item)ModItems.BAMBOO_BOARD.get()}) {
            String woodName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)wood)).m_135815_().replace("_board", "");
            Item output = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("handcrafted", woodName + "_" + suffix));
            assert (output != null);
            ShapedRecipeBuilder recipe = func.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126145_(suffix).m_126132_("has_" + suffix, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)wood)));
            recipe.m_176498_(consumer);
        }
    }

    public static void createWoodSetRecipeWithPlanks(Consumer<FinishedRecipe> consumer, String suffix, int count, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> func) {
        for (Item wood : new Item[]{(Item)ModItems.ACACIA_BOARD.get(), (Item)ModItems.BIRCH_BOARD.get(), (Item)ModItems.DARK_OAK_BOARD.get(), (Item)ModItems.JUNGLE_BOARD.get(), (Item)ModItems.MANGROVE_BOARD.get(), (Item)ModItems.OAK_BOARD.get(), (Item)ModItems.SPRUCE_BOARD.get(), (Item)ModItems.CRIMSON_BOARD.get(), (Item)ModItems.WARPED_BOARD.get(), (Item)ModItems.CHERRY_BOARD.get(), (Item)ModItems.BAMBOO_BOARD.get()}) {
            String woodName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)wood)).m_135815_().replace("_board", "");
            Item planks = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(woodName + "_planks"));
            Item output = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("handcrafted", woodName + "_" + suffix));
            assert (output != null);
            assert (planks != null);
            ShapedRecipeBuilder recipe = func.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126127_(Character.valueOf('/'), (ItemLike)planks).m_126145_(suffix).m_126132_("has_" + suffix, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)wood)));
            recipe.m_176498_(consumer);
        }
    }

    public static void createColouredSetRecipe(Consumer<FinishedRecipe> consumer, String suffix, int count, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> func) {
        for (Item wood : new Item[]{Items.f_41938_, Items.f_41934_, Items.f_41935_, Items.f_41932_, Items.f_41877_, Items.f_41936_, Items.f_41873_, Items.f_41878_, Items.f_41875_, Items.f_41872_, Items.f_41871_, Items.f_41876_, Items.f_41933_, Items.f_41937_, Items.f_41870_, Items.f_41874_}) {
            String color = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)wood)).m_135815_().replace("_wool", "");
            Item output = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("handcrafted", color + "_" + suffix));
            assert (output != null);
            ShapedRecipeBuilder recipe = func.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126145_(suffix).m_126132_("has_" + suffix, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)wood)));
            recipe.m_176498_(consumer);
        }
    }

    public static void createTrim(Consumer<FinishedRecipe> consumer, String suffix, int count, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> func) {
        for (Item wood : new Item[]{Items.f_42170_, Items.f_42755_, Items.f_41995_, Items.f_151047_, Items.f_151034_, Items.f_42064_, Items.f_151054_, Items.f_41958_, Items.f_42157_, Items.f_41905_}) {
            String trimName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)wood)).m_135815_().replace("_block", "");
            Item output = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("handcrafted", trimName + "_" + suffix));
            assert (output != null);
            ShapedRecipeBuilder recipe = func.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126145_(suffix).m_126132_("has_" + suffix, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)wood)));
            recipe.m_176498_(consumer);
        }
    }

    public static void createWallTrophy(Consumer<FinishedRecipe> consumer, Item output, int count, Item input) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_206416_(Character.valueOf('#'), ModTags.BOARDS).m_126127_(Character.valueOf('/'), (ItemLike)input).m_126145_("trophy").m_126132_("has_trophy", (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ModTags.BOARDS)).m_126130_("###").m_126130_("#/#").m_126130_("###").m_176498_(consumer);
    }

    public static void createStatueTrophy(Consumer<FinishedRecipe> consumer, Item output, int count, Item input) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41905_).m_126127_(Character.valueOf('/'), (ItemLike)input).m_126145_("trophy").m_126132_("has_trophy", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_41905_)).m_126130_(" # ").m_126130_("#/#").m_126130_("# #").m_176498_(consumer);
    }
}

