/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.startup;

import java.util.HashSet;
import java.util.Set;
import mezz.jei.forge.events.PermanentEventSubscriptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StartEventObserver {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Event>> requiredEvents = Set.of(TagsUpdatedEvent.class, RecipesUpdatedEvent.class);
    private final Set<Class<? extends Event>> observedEvents = new HashSet<Class<? extends Event>>();
    private final Runnable startRunnable;
    private final Runnable stopRunnable;
    private State state = State.DISABLED;

    public StartEventObserver(Runnable startRunnable, Runnable stopRunnable) {
        this.startRunnable = startRunnable;
        this.stopRunnable = stopRunnable;
    }

    public void register(PermanentEventSubscriptions subscriptions) {
        requiredEvents.forEach(eventClass -> subscriptions.register(eventClass, this::onEvent));
        subscriptions.register(ClientPlayerNetworkEvent.LoggingIn.class, event -> {
            if (event.getPlayer() != null) {
                LOGGER.info("JEI StartEventObserver received {}", event.getClass());
                if (this.state == State.DISABLED) {
                    this.transitionState(State.ENABLED);
                }
            }
        });
        subscriptions.register(ClientPlayerNetworkEvent.LoggingOut.class, event -> {
            if (event.getPlayer() != null) {
                LOGGER.info("JEI StartEventObserver received {}", event.getClass());
                this.transitionState(State.DISABLED);
            }
        });
        subscriptions.register(ScreenEvent.Init.Pre.class, event -> {
            if (this.state != State.JEI_STARTED) {
                Screen screen = event.getScreen();
                Minecraft minecraft = screen.getMinecraft();
                if (screen instanceof AbstractContainerScreen && minecraft != null && minecraft.f_91074_ != null) {
                    LOGGER.error("A Screen is opening but JEI hasn't started yet.\nNormally, JEI is started after ClientPlayerNetworkEvent.LoggedInEvent, TagsUpdatedEvent, and RecipesUpdatedEvent.\nSomething has caused one or more of these events to fail, so JEI is starting very late.");
                    this.transitionState(State.DISABLED);
                    this.transitionState(State.ENABLED);
                    this.transitionState(State.JEI_STARTED);
                }
            }
        });
    }

    private <T extends Event> void onEvent(T event) {
        if (this.state == State.DISABLED) {
            return;
        }
        LOGGER.info("JEI StartEventObserver received {}", event.getClass());
        Class<?> eventClass = event.getClass();
        if (requiredEvents.contains(eventClass) && this.observedEvents.add(eventClass) && this.observedEvents.containsAll(requiredEvents)) {
            if (this.state == State.JEI_STARTED) {
                this.restart();
            } else {
                this.transitionState(State.JEI_STARTED);
            }
        }
    }

    private void restart() {
        if (this.state != State.JEI_STARTED) {
            return;
        }
        this.transitionState(State.DISABLED);
        this.transitionState(State.ENABLED);
        this.transitionState(State.JEI_STARTED);
    }

    private void transitionState(State newState) {
        LOGGER.info("JEI StartEventObserver transitioning state from " + this.state + " to " + newState);
        switch (newState) {
            case DISABLED: {
                if (this.state != State.JEI_STARTED) break;
                this.stopRunnable.run();
                break;
            }
            case ENABLED: {
                if (this.state == State.DISABLED) break;
                throw new IllegalStateException("Attempted Illegal state transition from " + this.state + " to " + newState);
            }
            case JEI_STARTED: {
                if (this.state != State.ENABLED) {
                    throw new IllegalStateException("Attempted Illegal state transition from " + this.state + " to " + newState);
                }
                this.startRunnable.run();
            }
        }
        this.state = newState;
        this.observedEvents.clear();
    }

    private static enum State {
        DISABLED,
        ENABLED,
        JEI_STARTED;

    }
}

