/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.widgets.AbstractScrollWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.joml.Matrix4f;

public class ScrollBoxRecipeWidget
extends AbstractScrollWidget
implements IScrollBoxWidget,
IJeiInputHandler {
    private final int visibleHeight;
    private final int hiddenHeight;
    private final ScreenRectangle contentsArea;
    private final IDrawable contents;

    public ScrollBoxRecipeWidget(IDrawable contents, int visibleHeight, int xPos, int yPos) {
        super(new ScreenRectangle(xPos, yPos, contents.getWidth() + AbstractScrollWidget.getScrollBoxScrollbarExtraWidth(), visibleHeight));
        this.contents = contents;
        this.visibleHeight = visibleHeight;
        this.contentsArea = new ScreenRectangle(0, 0, contents.getWidth(), visibleHeight);
        this.hiddenHeight = Math.max(contents.getHeight() - visibleHeight, 0);
    }

    @Override
    protected int getVisibleAmount() {
        return this.visibleHeight;
    }

    @Override
    protected int getHiddenAmount() {
        return this.hiddenHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawContents(GuiGraphics guiGraphics, double mouseX, double mouseY, float scrollOffsetY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f pose = last.m_252922_();
        ScreenRectangle scissorArea = MathUtil.transform(this.contentsArea, pose);
        guiGraphics.m_280588_(scissorArea.m_274563_(), scissorArea.m_274449_(), scissorArea.m_274445_(), scissorArea.m_274349_());
        poseStack.m_85836_();
        float scrollAmount = (float)this.hiddenHeight * scrollOffsetY;
        poseStack.m_85837_(0.0, (double)(-scrollAmount), 0.0);
        try {
            this.contents.draw(guiGraphics);
        }
        finally {
            poseStack.m_85849_();
            guiGraphics.m_280618_();
        }
    }

    @Override
    protected float calculateScrollAmount(double scrollDeltaY) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        int smoothScrollRate = clientConfig.getSmoothScrollRate();
        int totalHeight = this.contents.getHeight();
        double scrollAmount = scrollDeltaY * (double)smoothScrollRate;
        return (float)(scrollAmount / (double)totalHeight);
    }
}

