/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IngredientSortStage;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.common.config.file.serializers.ListSerializer;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    @Nullable
    private static IClientConfig instance;
    private final Supplier<Boolean> centerSearchBarEnabled;
    private final Supplier<Boolean> lowMemorySlowSearchEnabled;
    private final Supplier<Boolean> cheatToHotbarUsingHotkeysEnabled;
    private final Supplier<Boolean> addBookmarksToFront;
    private final Supplier<Boolean> lookupFluidContents;
    private final Supplier<GiveMode> giveMode;
    private final Supplier<Integer> maxRecipeGuiHeight;
    private final Supplier<List<IngredientSortStage>> ingredientSorterStages;

    public ClientConfig(IConfigSchemaBuilder schema) {
        instance = this;
        IConfigCategoryBuilder advanced = schema.addCategory("advanced");
        this.centerSearchBarEnabled = advanced.addBoolean("CenterSearch", false, "Display search bar in the center");
        this.lowMemorySlowSearchEnabled = advanced.addBoolean("LowMemorySlowSearchEnabled", false, "Set low-memory mode (makes search very slow, but uses less RAM)");
        this.cheatToHotbarUsingHotkeysEnabled = advanced.addBoolean("CheatToHotbarUsingHotkeysEnabled", false, "Enable cheating items into the hotbar by using the shift+number keys.");
        this.addBookmarksToFront = advanced.addBoolean("AddBookmarksToFrontEnabled", true, "Enable adding new bookmarks to the front of the bookmark list.");
        this.lookupFluidContents = advanced.addBoolean("LookupFluidContents", false, "When looking up recipes with items that contain fluids, also look up recipes for the fluids.");
        this.giveMode = advanced.addEnum("GiveMode", GiveMode.defaultGiveMode, "How items should be handed to you");
        this.maxRecipeGuiHeight = advanced.addInteger("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE, "Max. recipe gui height");
        IConfigCategoryBuilder sorting = schema.addCategory("sorting");
        this.ingredientSorterStages = sorting.addList("IngredientSortStages", IngredientSortStage.defaultStages, new ListSerializer<IngredientSortStage>(new EnumSerializer<IngredientSortStage>(IngredientSortStage.class)), "Sorting order for the ingredient list");
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return this.centerSearchBarEnabled.get();
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return this.lowMemorySlowSearchEnabled.get();
    }

    @Override
    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    @Override
    public boolean isAddingBookmarksToFront() {
        return this.addBookmarksToFront.get();
    }

    @Override
    public boolean isLookupFluidContents() {
        return this.lookupFluidContents.get();
    }

    @Override
    public GiveMode getGiveMode() {
        return this.giveMode.get();
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return this.maxRecipeGuiHeight.get();
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages.get();
    }
}

