/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.blocks;

import com.mojang.datafixers.util.Pair;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.blocks.CakeEffectsHolder;
import einstein.jmc.data.CakeEffects;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.util.CakeBuilder;
import einstein.jmc.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseCakeBlock
extends Block
implements CakeEffectsHolder {
    public static final IntegerProperty BITES = BlockStateProperties.f_61412_;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};
    private final boolean allowsCandles;
    private final int biteCount;
    private CakeBuilder builder;
    private CakeEffects cakeEffects;

    protected BaseCakeBlock(CakeBuilder builder, int biteCount) {
        this(builder.getCakeProperties(), builder.allowsCandles(), biteCount);
        this.builder = builder;
    }

    public BaseCakeBlock(CakeBuilder builder) {
        this(builder, 6);
    }

    public BaseCakeBlock(BlockBehaviour.Properties properties, boolean allowsCandles, int biteCount) {
        super(properties);
        this.allowsCandles = allowsCandles;
        this.biteCount = biteCount;
        if (this.getBiteCount() > 0) {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getBites(), (Comparable)Integer.valueOf(0)));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getShapeByBite()[(Integer)state.m_61143_((Property)this.getBites())];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.allowsCandles && itemstack.m_204117_(ItemTags.f_144319_) && (this.getBiteCount() <= 0 || (Integer)state.m_61143_((Property)this.getBites()) == 0) && (block = Block.m_49814_((Item)item)) instanceof CandleBlock) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_144090_, SoundSource.BLOCKS, 1.0f, 1.0f);
            Block candleCake = (Block)this.builder.getCandleCakeByCandle().get(block).get();
            level.m_46597_(pos, candleCake.m_49966_());
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            if (this.eat(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            JustMoreCakes.CAKE_EATEN_TRIGGER.trigger(serverPlayer, this);
        }
        return this.eat(level, pos, state, player);
    }

    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(((Integer)this.getNourishment().getFirst()).intValue(), ((Float)this.getNourishment().getSecond()).floatValue());
        state = this.eatActions(player, pos, state);
        if (this.cakeEffects != null) {
            for (CakeEffects.MobEffectHolder holder : this.cakeEffects.mobEffects()) {
                MobEffectInstance instance = new MobEffectInstance(holder.effect(), holder.duration().orElse(0).intValue(), holder.amplifier().orElse(0).intValue());
                if (holder.effect().m_8093_()) {
                    instance.m_19544_().m_19461_((Entity)player, (Entity)player, (LivingEntity)player, instance.m_19564_(), 1.0);
                    continue;
                }
                player.m_7292_(instance);
            }
        }
        int i = (Integer)state.m_61143_((Property)this.getBites());
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (i < this.getBiteCount()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getBites(), (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.m_7471_(pos, false);
            level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState eatActions(Player player, BlockPos pos, BlockState state) {
        if (this.equals(ModBlocks.FIREY_CAKE.get())) {
            player.m_20254_(((Integer)ModCommonConfigs.FIREY_CAKE_ON_FIRE_DUR.get()).intValue());
        } else if (this.equals(ModBlocks.ICE_CAKE.get())) {
            player.m_20095_();
        } else if (this.equals(ModBlocks.CHORUS_CAKE.get())) {
            Util.teleportRandomly((LivingEntity)player, (Double)ModCommonConfigs.CHORUS_CAKE_TELEPORT_RADIUS.get());
        } else if (this.equals(ModBlocks.ENDER_CAKE.get())) {
            Util.teleportRandomly((LivingEntity)player, (Double)ModCommonConfigs.ENDER_CAKE_TELEPORT_RADIUS.get());
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getBites()});
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (this.getBiteCount() + 1 - (Integer)state.m_61143_((Property)this.getBites())) * 2;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computation) {
        return false;
    }

    @Nullable
    public IntegerProperty getBites() {
        return BITES;
    }

    public VoxelShape[] getShapeByBite() {
        return SHAPE_BY_BITE;
    }

    public int getBiteCount() {
        return this.biteCount;
    }

    public CakeBuilder getBuilder() {
        return this.builder;
    }

    @Override
    @Nullable
    public CakeEffects getCakeEffects() {
        return this.cakeEffects;
    }

    @Override
    public void setCakeEffects(CakeEffects cakeEffects) {
        this.cakeEffects = cakeEffects;
    }

    protected Pair<Integer, Float> getNourishment() {
        return Pair.of((Object)2, (Object)Float.valueOf(0.1f));
    }
}

