/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.blocks;

import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.init.ModGameEvents;
import einstein.jmc.init.ModItems;
import einstein.jmc.util.CakeBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;

public class SculkCakeBlock
extends BaseCakeBlock {
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.f_155999_;

    public SculkCakeBlock(CakeBuilder builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PHASE, (Comparable)SculkSensorPhase.INACTIVE));
    }

    @Override
    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (SculkCakeBlock.canActivate(state)) {
            return super.eat(level, pos, state, player);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState eatActions(Player player, BlockPos pos, BlockState state) {
        player.m_9236_().m_142346_((Entity)player, ModGameEvents.SCULK_CAKE_EATEN.get(), pos);
        return SculkCakeBlock.activate((Entity)player, player.m_9236_(), pos, state);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (SculkSensorBlock.m_154487_((BlockState)state) != SculkSensorPhase.ACTIVE) {
            if (SculkSensorBlock.m_154487_((BlockState)state) == SculkSensorPhase.COOLDOWN) {
                level.m_7731_(pos, (BlockState)state.m_61124_(PHASE, (Comparable)SculkSensorPhase.INACTIVE), 3);
                level.m_5594_(null, pos, SoundEvents.f_144213_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.8f);
            }
        } else {
            SculkCakeBlock.deactivate((Level)level, pos, state);
        }
    }

    public void m_6810_(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$0.m_60713_($$3.m_60734_())) {
            if (SculkSensorBlock.m_154487_((BlockState)$$0) == SculkSensorPhase.ACTIVE) {
                SculkCakeBlock.updateNeighbours($$1, $$2, $$0);
            }
            super.m_6810_($$0, $$1, $$2, $$3, $$4);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction;
        if (SculkSensorBlock.m_154487_((BlockState)state) == SculkSensorPhase.ACTIVE && (direction = Direction.m_235672_((RandomSource)random)) != Direction.UP && direction != Direction.DOWN) {
            double x = (double)pos.m_123341_() + 0.5 + (direction.m_122429_() == 0 ? 0.5 - random.m_188500_() : (double)direction.m_122429_() * 0.6);
            double y = (double)pos.m_123342_() + 0.25;
            double z = (double)pos.m_123343_() + 0.5 + (direction.m_122431_() == 0 ? 0.5 - random.m_188500_() : (double)direction.m_122431_() * 0.6);
            double ySpeed = (double)random.m_188501_() * 0.04;
            level.m_7106_((ParticleOptions)DustColorTransitionOptions.f_175752_, x, y, z, 0.0, ySpeed, 0.0);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PHASE}));
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.m_213646_(state, level, pos, stack, dropExperience);
        if (dropExperience && !stack.m_150930_(ModItems.CAKE_SPATULA.get())) {
            this.m_220822_(level, pos, stack, (IntProvider)ConstantInt.m_146483_((int)5));
        }
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return super.m_6782_(state, level, pos) + (SculkSensorBlock.m_154487_((BlockState)state) == SculkSensorPhase.ACTIVE ? 1 : 0);
    }

    private static void updateNeighbours(Level level, BlockPos pos, BlockState $$2) {
        Block block = $$2.m_60734_();
        level.m_46672_(pos, block);
        level.m_46672_(pos.m_7495_(), block);
    }

    public static boolean canActivate(BlockState blockState) {
        return SculkSensorBlock.m_154487_((BlockState)blockState) == SculkSensorPhase.INACTIVE;
    }

    public static void deactivate(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_(PHASE, (Comparable)SculkSensorPhase.COOLDOWN), 3);
        level.m_186460_(pos, state.m_60734_(), 10);
        SculkCakeBlock.updateNeighbours(level, pos, state);
    }

    public static BlockState activate(@Nullable Entity entity, Level level, BlockPos pos, BlockState state) {
        state = (BlockState)state.m_61124_(PHASE, (Comparable)SculkSensorPhase.ACTIVE);
        level.m_7731_(pos, state, 3);
        level.m_186460_(pos, state.m_60734_(), 30);
        SculkCakeBlock.updateNeighbours(level, pos, state);
        level.m_142346_(entity, GameEvent.f_223700_, pos);
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_144212_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.8f);
        return state;
    }
}

