/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.providers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.data.CakeEffects;
import einstein.jmc.util.Util;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public abstract class CakeEffectsProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final Map<String, JsonElement> map = new HashMap<String, JsonElement>();

    public CakeEffectsProvider(PackOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    protected abstract void addCakeEffects();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addCakeEffects();
        Path folderPath = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("cake_effects");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        this.map.forEach((name, element) -> {
            Path filePath = folderPath.resolve(name + ".json");
            builder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)element, (Path)filePath));
        });
        return CompletableFuture.allOf((CompletableFuture[])builder.build().toArray(CompletableFuture[]::new));
    }

    public void add(Supplier<BaseCakeBlock> cake, CakeEffects.MobEffectHolder ... mobEffects) {
        JsonElement element = (JsonElement)CakeEffects.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new CakeEffects(cake.get(), List.of(mobEffects))).getOrThrow(false, s -> {});
        this.map.put(Util.getBlockId(cake.get()).m_135815_(), element);
    }

    public String m_6055_() {
        return "Cake Effects";
    }
}

