/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.providers;

import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.blocks.BaseCandleCakeBlock;
import einstein.jmc.blocks.ThreeTieredCandleCakeBlock;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.util.CakeBuilder;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "jmc", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock(ModBlocks.ENCASING_ICE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("encasing_ice", this.mcLoc("ice"))).renderType("translucent"));
        this.defaultCakeBlock(ModBlocks.TNT_CAKE.get());
        this.defaultCakeBlock(ModBlocks.POISON_CAKE.get());
        this.crossCakeBlock(ModBlocks.BROWN_MUSHROOM_CAKE.get(), this.mcLoc("block/brown_mushroom"));
        this.crossCakeBlock(ModBlocks.RED_MUSHROOM_CAKE.get(), this.mcLoc("block/red_mushroom"));
        this.crossCakeBlock(ModBlocks.CHORUS_CAKE.get(), this.modLoc("block/chorus_cake_flower"));
        this.crossCakeBlock(ModBlocks.CRIMSON_FUNGUS_CAKE.get(), this.mcLoc("block/crimson_fungus"));
        for (Supplier<BaseCakeBlock> cake : CakeBuilder.BUILDER_BY_CAKE.keySet()) {
            CakeBuilder builder = CakeBuilder.BUILDER_BY_CAKE.get(cake);
            if (builder.hasCustomBlockModel()) continue;
            this.cakeBlock((BaseCakeBlock)cake.get(), builder.getCakeName());
            if (!builder.allowsCandles()) continue;
            for (Block candle : builder.getCandleCakeByCandle().keySet()) {
                Supplier<BaseCandleCakeBlock> candleCake = builder.getCandleCakeByCandle().get(candle);
                this.candleCakeBlock((Block)candleCake.get(), ModBlocks.SUPPORTED_CANDLES.get(candle), builder.getCakeName());
            }
        }
        CakeBuilder threeTieredBuilder = ModBlocks.THREE_TIERED_CAKE.get().getBuilder();
        for (Block candle : threeTieredBuilder.getCandleCakeByCandle().keySet()) {
            ResourceLocation type = ModBlocks.SUPPORTED_CANDLES.get(candle);
            this.getVariantBuilder((Block)threeTieredBuilder.getCandleCakeByCandle().get(candle).get()).partialState().with((Property)ThreeTieredCandleCakeBlock.f_151895_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent(type.m_135815_() + "candle_three_tiered_cake", this.modLoc("template_three_tiered_candle_cake"))).texture("candle", new ResourceLocation(type.m_135827_(), "block/" + type.m_135815_() + "candle")))}).partialState().with((Property)ThreeTieredCandleCakeBlock.f_151895_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent(type.m_135815_() + "candle_three_tiered_cake_lit", this.modLoc("template_three_tiered_candle_cake"))).texture("candle", new ResourceLocation(type.m_135827_(), "block/" + type.m_135815_() + "candle_lit")))});
        }
        CakeBuilder sculkBuilder = ModBlocks.SCULK_CAKE.get().getBuilder();
        for (Block candle : sculkBuilder.getCandleCakeByCandle().keySet()) {
            Supplier<BaseCandleCakeBlock> candleCake = sculkBuilder.getCandleCakeByCandle().get(candle);
            this.candleCakeBlock((Block)candleCake.get(), ModBlocks.SUPPORTED_CANDLES.get(candle), sculkBuilder.getCakeName());
        }
    }

    private void cakeBlock(BaseCakeBlock cake, String name) {
        String side = "block/" + name + "_side";
        String top = "block/" + name + "_top";
        String bottom = "block/" + name + "_bottom";
        String inside = "block/" + name + "_inner";
        if (cake.getBiteCount() > 0) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
            builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_cake"))).texture("side", side)).texture("top", top)).texture("bottom", bottom))});
            for (int i = 1; i < 7; ++i) {
                builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slice" + i, this.modLoc("template_cake_slice" + i))).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("inside", inside))});
            }
        } else {
            this.simpleBlock(cake, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_cake"))).texture("side", side)).texture("top", top)).texture("bottom", bottom));
        }
    }

    private void candleCakeBlock(Block block, ResourceLocation type, String name) {
        String fileName = type.m_135815_() + "candle_" + name;
        String path = "block/" + name;
        this.getVariantBuilder(block).partialState().with((Property)BaseCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fileName, this.mcLoc("template_cake_with_candle"))).texture("side", path + "_side")).texture("top", path + "_top")).texture("bottom", path + "_bottom")).texture("candle", new ResourceLocation(type.m_135827_(), "block/" + type.m_135815_() + "candle"))).texture("particle", "#side"))}).partialState().with((Property)BaseCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fileName + "_lit", this.mcLoc("template_cake_with_candle"))).texture("side", path + "_side")).texture("top", path + "_top")).texture("bottom", path + "_bottom")).texture("candle", new ResourceLocation(type.m_135827_(), "block/" + type.m_135815_() + "candle_lit"))).texture("particle", "#side"))});
    }

    private void crossCakeBlock(BaseCakeBlock cake, ResourceLocation cross) {
        String name = cake.getBuilder().getCakeName();
        String side = "block/" + name + "_side";
        String top = "block/" + name + "_top";
        String bottom = "block/" + name + "_bottom";
        String inside = "block/" + name + "_inner";
        if (cake.getBiteCount() > 0) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
            builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_cross_cake"))).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("cross", cross)).renderType(this.mcLoc("cutout")))});
            for (int i = 1; i < 7; ++i) {
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slice" + i, this.modLoc("template_cross_cake_slice" + i))).renderType(this.mcLoc("cutout"))).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("inside", inside);
                if (i < 4) {
                    model.texture("cross", cross);
                }
                builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            }
        } else {
            this.simpleBlock(cake, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_cross_cake"))).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("cross", cross)).renderType(this.mcLoc("cutout")));
        }
    }

    private void defaultCakeBlock(BaseCakeBlock cake) {
        CakeBuilder cakeBuilder = cake.getBuilder();
        if (cake.getBiteCount() > 0) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
            builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("cake")))});
            for (int i = 1; i < 7; ++i) {
                builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("cake_slice" + i)))});
            }
        } else {
            this.simpleBlock(cake, (ModelFile)this.models().getExistingFile(this.mcLoc("cake")));
        }
        if (cakeBuilder.allowsCandles()) {
            for (Block candle : cakeBuilder.getCandleCakeByCandle().keySet()) {
                ResourceLocation type = ModBlocks.SUPPORTED_CANDLES.get(candle);
                this.getVariantBuilder((Block)cakeBuilder.getCandleCakeByCandle().get(candle).get()).partialState().with((Property)BaseCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation(type.m_135827_(), type.m_135815_() + "candle_cake")))}).partialState().with((Property)BaseCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation(type.m_135827_(), type.m_135815_() + "candle_cake_lit")))});
            }
        }
    }
}

