/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import einstein.jmc.init.ModVillagers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HarvestSugarCane
extends Behavior<Villager> {
    @Nullable
    private BlockPos sugarCanePos;
    private long nextStartTime;
    private int timeWorked;
    private final List<BlockPos> validSugarCanePositions = new ArrayList<BlockPos>();

    public HarvestSugarCane() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26363_, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Villager villager) {
        if (!level.m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        if (villager.m_7141_().m_35571_() != ModVillagers.CAKE_BAKER.get()) {
            return false;
        }
        this.validSugarCanePositions.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(villager.m_20185_() + (double)x, villager.m_20186_() + (double)y, villager.m_20189_() + (double)z);
                    if (!this.validPos((BlockPos)pos, level)) continue;
                    this.validSugarCanePositions.add((BlockPos)pos);
                }
            }
        }
        this.sugarCanePos = this.getValidSugarCane(level);
        return this.sugarCanePos != null;
    }

    private boolean validPos(BlockPos pos, ServerLevel level) {
        BlockState state = level.m_8055_(pos);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return state.m_60734_() instanceof SugarCaneBlock && belowState.m_60734_() instanceof SugarCaneBlock;
    }

    @Nullable
    private BlockPos getValidSugarCane(ServerLevel level) {
        return this.validSugarCanePositions.isEmpty() ? null : this.validSugarCanePositions.get(level.m_213780_().m_188503_(this.validSugarCanePositions.size()));
    }

    protected void start(ServerLevel level, Villager villager, long gameTime) {
        if (gameTime > this.nextStartTime && this.sugarCanePos != null) {
            this.setMemories(villager);
        }
    }

    protected void stop(ServerLevel level, Villager villager, long gameTime) {
        Brain brain = villager.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26371_);
        brain.m_21936_(MemoryModuleType.f_26370_);
        this.timeWorked = 0;
        this.nextStartTime = gameTime + 40L;
    }

    protected void tick(ServerLevel level, Villager villager, long gameTime) {
        if (this.sugarCanePos == null || this.sugarCanePos.m_203195_((Position)villager.m_20182_().m_82520_(0.0, 1.0, 0.0), 1.0)) {
            BlockState state;
            Block block;
            if (this.sugarCanePos != null && gameTime > this.nextStartTime && (block = (state = level.m_8055_(this.sugarCanePos)).m_60734_()) instanceof SugarCaneBlock) {
                level.m_46953_(this.sugarCanePos, true, (Entity)villager);
                this.validSugarCanePositions.remove(this.sugarCanePos);
                this.sugarCanePos = this.getValidSugarCane(level);
                if (this.sugarCanePos != null) {
                    this.nextStartTime = gameTime + 20L;
                    this.setMemories(villager);
                }
            }
            ++this.timeWorked;
        }
    }

    protected boolean canStillUse(ServerLevel level, Villager villager, long gameTime) {
        return this.timeWorked < 200;
    }

    private void setMemories(Villager villager) {
        if (this.sugarCanePos != null) {
            Brain brain = villager.m_6274_();
            BlockPosTracker tracker = new BlockPosTracker(this.sugarCanePos);
            brain.m_21879_(MemoryModuleType.f_26371_, (Object)tracker);
            brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)tracker, 0.5f, 1));
        }
    }
}

