/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting;

import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.util.CakeOvenConstants;
import einstein.jmc.util.RecipeMatcher;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CakeOvenRecipe
implements Recipe<Container>,
CakeOvenConstants {
    protected final ResourceLocation id;
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;
    protected final NonNullList<Ingredient> ingredients;

    public CakeOvenRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, float experience, int cookingTime) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public boolean m_5818_(Container container, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int stackCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack;
            if (i == 5 || i == 4 || (stack = container.m_8020_(i)).m_41619_()) continue;
            ++stackCount;
            inputs.add(stack);
        }
        return stackCount == this.ingredients.size() && RecipeMatcher.findMatches(inputs, this.ingredients) != null;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.CAKE_OVEN_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.CAKE_OVEN_RECIPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.CAKE_OVEN.get());
    }

    public void consumeIngredients(Container container, NonNullList<ItemStack> remainingItems) {
        for (Ingredient ingredient : this.ingredients) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack;
                if (i == 5 || i == 4 || (stack = container.m_8020_(i)).m_41619_() || !ingredient.test(stack)) continue;
                boolean hasRemainingItem = stack.m_41720_().m_41470_();
                Item v = stack.m_41720_().m_41469_();
                ItemStack remainingStack = v == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)v);
                int i2 = 0;
                for (int i3 = 0; i3 < remainingItems.size(); ++i3) {
                    ItemStack remainingItem = (ItemStack)remainingItems.get(i3);
                    if (!remainingItem.m_41619_()) {
                        if (!ItemStack.m_150942_((ItemStack)remainingStack, (ItemStack)remainingItem)) continue;
                        remainingItem.m_41769_(remainingStack.m_41613_());
                        remainingItems.set(i3, (Object)remainingItem);
                        remainingStack = (ItemStack)remainingItems.get(i3);
                        i2 = i3;
                        break;
                    }
                    remainingItem = remainingStack.m_41777_();
                    remainingItems.set(i3, (Object)remainingItem);
                    remainingStack = (ItemStack)remainingItems.get(i3);
                    i2 = i3;
                    break;
                }
                stack.m_41774_(1);
                if (stack.m_41619_() && hasRemainingItem) {
                    container.m_6836_(i, remainingStack.m_41777_());
                    remainingItems.set(i2, (Object)ItemStack.f_41583_);
                    continue;
                }
                if (!stack.m_41619_()) continue;
                container.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }
}

