/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.platform.services;

import einstein.jmc.util.BlockEntitySupplier;
import einstein.jmc.util.MenuTypeSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;

public interface RegistryHelper {
    public static final List<Supplier<? extends Item>> CREATIVE_TAB_ITEMS = new ArrayList<Supplier<? extends Item>>();

    public <T extends Item> Supplier<T> registerItem(String var1, Supplier<T> var2);

    default public <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> type) {
        Supplier block = this.registerBlockNoItem(name, type);
        this.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <T extends Block> Supplier<T> registerBlockNoItem(String var1, Supplier<T> var2);

    public <T extends BlockEntityType<?>> Supplier<T> registerBlockEntity(String var1, Supplier<T> var2);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntity(BlockEntitySupplier<T> var1, Block ... var2);

    public <T extends Potion> Supplier<T> registerPotion(String var1, Supplier<T> var2);

    public <T extends MobEffect> Supplier<T> registerMobEffect(String var1, Supplier<T> var2);

    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipeSerializer(String var1, Supplier<T> var2);

    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(String var1, Supplier<T> var2);

    public <T extends MenuType<?>> Supplier<T> registerMenuType(String var1, Supplier<T> var2);

    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuTypeSupplier<T> var1);

    public <T extends PoiType> Supplier<T> registerPOIType(String var1, Supplier<T> var2);

    public <T extends VillagerProfession> Supplier<T> registerVillagerProfession(String var1, Supplier<T> var2);

    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String var1, Function<CreativeModeTab.Builder, T> var2);

    public <T extends GameEvent> Supplier<GameEvent> registerGameEvent(String var1, Supplier<T> var2);
}

