/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.util;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.blocks.BaseCandleCakeBlock;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class CakeBuilder {
    public static final Map<Supplier<BaseCakeBlock>, CakeBuilder> BUILDER_BY_CAKE = new HashMap<Supplier<BaseCakeBlock>, CakeBuilder>();
    private final String cakeName;
    private final boolean allowsCandles;
    private final boolean customBlockModel;
    private final boolean customItemModel;
    private final Map<Block, Supplier<BaseCandleCakeBlock>> candleCakeByCandle = new HashMap<Block, Supplier<BaseCandleCakeBlock>>();
    private CakeClazzSupplier<?> cakeClazz;
    private CandleCakeClazzSupplier<?> candleCakeClazz;
    private BlockBehaviour.Properties cakeProperties;
    private BlockBehaviour.Properties candleCakeProperties;

    public CakeBuilder(String cakeName, boolean allowsCandles, boolean customBlockModel, boolean customItemModel) {
        this.cakeName = cakeName;
        this.allowsCandles = allowsCandles;
        this.customBlockModel = customBlockModel;
        this.customItemModel = customItemModel;
    }

    public CakeBuilder(String cakeName, boolean allowsCandles, boolean customBlockModel) {
        this(cakeName, allowsCandles, customBlockModel, false);
    }

    public CakeBuilder(String cakeName, boolean allowsCandles) {
        this(cakeName, allowsCandles, false);
    }

    public <T extends BaseCakeBlock> CakeBuilder setCakeClass(CakeClazzSupplier<T> clazz) {
        this.cakeClazz = clazz;
        return this;
    }

    public <T extends BaseCandleCakeBlock> CakeBuilder setCandleCakeClass(CandleCakeClazzSupplier<T> clazz) {
        this.candleCakeClazz = clazz;
        return this;
    }

    public <T extends BaseCakeBlock, T2 extends BaseCandleCakeBlock> CakeBuilder setBothClasses(CakeClazzSupplier<T> cakeClazz, CandleCakeClazzSupplier<T2> candleCakeClazz) {
        this.cakeClazz = cakeClazz;
        this.candleCakeClazz = candleCakeClazz;
        return this;
    }

    public CakeBuilder setCakeProperties(BlockBehaviour.Properties properties) {
        this.cakeProperties = properties;
        return this;
    }

    public CakeBuilder setCandleCakeProperties(BlockBehaviour.Properties properties) {
        this.candleCakeProperties = properties;
        return this;
    }

    public Supplier<BaseCakeBlock> build() {
        if (ModBlocks.SUPPORTED_CANDLES.isEmpty()) {
            JustMoreCakes.AddSupportedCandles();
        }
        if (this.cakeClazz == null) {
            this.cakeClazz = BaseCakeBlock::new;
        }
        if (this.cakeProperties == null) {
            this.cakeProperties = ModBlocks.cakeProperties();
        }
        Supplier<BaseCakeBlock> cake = Services.REGISTRY.registerBlock(this.cakeName, () -> this.cakeClazz.get(this));
        if (this.allowsCandles) {
            if (this.candleCakeClazz == null) {
                this.candleCakeClazz = BaseCandleCakeBlock::new;
            }
            if (this.candleCakeProperties == null) {
                this.candleCakeProperties = ModBlocks.candleCakeProperties();
            }
            for (Block candle : ModBlocks.SUPPORTED_CANDLES.keySet()) {
                String type = ModBlocks.SUPPORTED_CANDLES.get(candle).m_135815_();
                Supplier<BaseCandleCakeBlock> coloredCandleCake = Services.REGISTRY.registerBlockNoItem(type + "candle_" + this.cakeName, () -> this.candleCakeClazz.get((BaseCakeBlock)cake.get(), this.candleCakeProperties));
                this.candleCakeByCandle.put(candle, coloredCandleCake);
            }
        }
        BUILDER_BY_CAKE.put(cake, this);
        return cake;
    }

    public String getCakeName() {
        return this.cakeName;
    }

    public Map<Block, Supplier<BaseCandleCakeBlock>> getCandleCakeByCandle() {
        return this.candleCakeByCandle;
    }

    public boolean allowsCandles() {
        return this.allowsCandles;
    }

    public boolean hasCustomBlockModel() {
        return this.customBlockModel;
    }

    public boolean hasCustomItemModel() {
        return this.customItemModel;
    }

    public BlockBehaviour.Properties getCakeProperties() {
        return this.cakeProperties;
    }

    @FunctionalInterface
    public static interface CakeClazzSupplier<T extends BaseCakeBlock> {
        public T get(CakeBuilder var1);
    }

    @FunctionalInterface
    public static interface CandleCakeClazzSupplier<T extends BaseCandleCakeBlock> {
        public T get(BaseCakeBlock var1, BlockBehaviour.Properties var2);
    }
}

