/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.blocks.BaseCandleCakeBlock;
import einstein.jmc.blocks.SculkCakeBlock;
import einstein.jmc.data.CakeEffects;
import einstein.jmc.init.ModItems;
import einstein.jmc.init.ModPotions;
import einstein.jmc.mixin.StructureTemplatePoolAccessor;
import einstein.jmc.util.CakeBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final Gson GSON = new GsonBuilder().create();
    private static final Random RANDOM = new Random();
    public static final LootItemCondition.Builder HAS_CAKE_SPATULA = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)ModItems.CAKE_SPATULA.get()}));

    public static <T extends Item> ResourceLocation getItemId(T item) {
        return BuiltInRegistries.f_257033_.m_7981_(item);
    }

    public static <T extends Block> ResourceLocation getBlockId(T block) {
        return BuiltInRegistries.f_256975_.m_7981_(block);
    }

    public static <T extends MobEffect> ResourceLocation getMobEffectId(T effect) {
        return BuiltInRegistries.f_256974_.m_7981_(effect);
    }

    public static void createExplosion(Level level, BlockPos pos, float size) {
        if (level.f_46443_) {
            return;
        }
        level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, size, Level.ExplosionInteraction.TNT);
    }

    public static boolean teleportRandomly(LivingEntity entity, double radius) {
        int attempts = 20;
        int tries = 0;
        boolean teleported = false;
        while (!teleported && tries++ <= attempts) {
            double x = entity.f_19854_ + (RANDOM.nextDouble() - RANDOM.nextDouble()) * radius;
            double y = entity.f_19855_ + (RANDOM.nextDouble() - RANDOM.nextDouble()) * radius;
            double z = entity.f_19856_ + (RANDOM.nextDouble() - RANDOM.nextDouble()) * radius;
            teleported = entity.m_20984_(x, y, z, true);
        }
        return teleported;
    }

    public static Block getBlock(ResourceLocation location) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(location);
        if (block != Blocks.f_50016_) {
            return block;
        }
        throw new NullPointerException("Could not find block: " + location);
    }

    public static boolean timeGoneBy(Level level, int ticks) {
        if (ticks == 0) {
            return true;
        }
        return level.m_46467_() % (long)ticks == 0L;
    }

    public static void useCake(Player player, BlockPos pos, InteractionHand hand, Supplier<Boolean> canInteract) {
        BaseCandleCakeBlock candleCake;
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!player.m_36391_(false)) {
            return;
        }
        if (!(block instanceof BaseCandleCakeBlock) && !(block instanceof BaseCakeBlock)) {
            return;
        }
        if (block instanceof BaseCakeBlock) {
            BaseCakeBlock cake = (BaseCakeBlock)block;
            if (player.m_21120_(hand).m_204117_(ItemTags.f_144319_) && state.m_61145_((Property)cake.getBites()).map(val -> val == 0).orElse(false).booleanValue()) {
                return;
            }
            if (cake.getBiteCount() <= 0) {
                return;
            }
        }
        if (block instanceof BaseCandleCakeBlock && (candleCake = (BaseCandleCakeBlock)block).getOriginalCake().getBiteCount() <= 0) {
            return;
        }
        if (block instanceof SculkCakeBlock && !SculkSensorBlock.m_154489_((BlockState)state)) {
            return;
        }
        if (canInteract.get().booleanValue()) {
            ItemStack blockStack = block.m_7397_((BlockGetter)level, pos, state);
            for (int i = 0; i < 16; ++i) {
                Vec3 vec3 = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3 = vec3.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
                vec3 = vec3.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
                double d0 = (double)(-RANDOM.nextFloat()) * 0.6 - 0.3;
                Vec3 vec31 = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec31 = vec31.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
                vec31 = vec31.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
                vec31 = vec31.m_82520_(player.m_20185_(), player.m_20188_(), player.m_20189_());
                ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, blockStack);
                Level level2 = player.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level2;
                    serverWorld.m_8767_((ParticleOptions)particle, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                    continue;
                }
                level.m_7106_((ParticleOptions)particle, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
            }
            player.m_5496_(player.m_7866_(blockStack), 0.5f + 0.5f * (float)RANDOM.nextInt(2), (RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public static void registerVillageBuilding(MinecraftServer server, String biome, String name, int weight) {
        String path = "jmc:village/" + biome + "/houses/" + biome + "_" + name;
        if (weight < 1) {
            return;
        }
        if (weight > 150) {
            JustMoreCakes.LOGGER.error("Failed to register village building: " + path + " - weight must be less than 150");
            return;
        }
        RegistryAccess.Frozen access = server.m_206579_();
        Registry templatePoolRegistry = (Registry)access.m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorRegistry = (Registry)access.m_6632_(Registries.f_257011_).orElseThrow();
        StructureTemplatePool templatePool = (StructureTemplatePool)templatePoolRegistry.m_7745_(JustMoreCakes.mcLoc("village/" + biome + "/houses"));
        if (templatePool == null) {
            JustMoreCakes.LOGGER.warn("Failed to register village building: " + path + "  - template pool is null");
            return;
        }
        StructurePoolElement structure = (StructurePoolElement)StructurePoolElement.m_210512_((String)path, (Holder)processorRegistry.m_246971_(ProcessorLists.f_127204_)).apply(StructureTemplatePool.Projection.RIGID);
        StructureTemplatePoolAccessor templateAccessor = (StructureTemplatePoolAccessor)templatePool;
        for (int i = 0; i < weight; ++i) {
            templateAccessor.getTemplates().add((Object)structure);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = new ArrayList<Pair<StructurePoolElement, Integer>>(templateAccessor.getRawTemplates());
        rawTemplates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)structure, (Object)weight));
        templateAccessor.setRawTemplates(rawTemplates);
    }

    public static Map<ResourceLocation, CakeEffects> deserializeCakeEffects(ResourceManager manager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map locations = manager.m_214159_("cake_effects", location -> location.m_135815_().endsWith(".json"));
        locations.forEach((location, resource) -> {
            try (InputStream stream = resource.m_215507_();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                JsonObject object = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                CakeEffects.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).resultOrPartial(error -> JustMoreCakes.LOGGER.error("Failed to decode cake effect with json id {} - Error: {}", location, error)).ifPresent(entry -> builder.put(location, entry));
            }
            catch (Exception exception) {
                JustMoreCakes.LOGGER.error("Error occurred while loading resource json " + location.toString(), (Throwable)exception);
            }
        });
        ImmutableMap map = builder.build();
        JustMoreCakes.LOGGER.info("Loaded {} cake effects", (Object)map.size());
        return map;
    }

    public static void livingEntityJump(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_21023_(ModPotions.BOUNCING_EFFECT.get())) {
            player.m_5997_(0.0, (double)0.15f, 0.0);
        }
    }

    public static void livingEntityTick(Level level, LivingEntity entity) {
        RandomSource random = entity.m_217043_();
        if (entity.m_21023_(ModPotions.BOUNCING_EFFECT.get()) && entity.f_19863_ && entity.m_20096_() && !entity.m_5803_()) {
            float f = 0.65f;
            if (entity.m_21023_(MobEffects.f_19603_)) {
                f += 0.1f * (float)(entity.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
            }
            entity.m_5997_(0.0, (double)f, 0.0);
            entity.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
            if (level.f_46443_) {
                for (int i = 0; i < 8; ++i) {
                    float f1 = random.m_188501_() * ((float)Math.PI * 2);
                    float f2 = random.m_188501_() * 0.5f + 0.5f;
                    float f3 = Mth.m_14031_((float)f1) * 1.0f * 0.5f * f2;
                    float f4 = Mth.m_14089_((float)f1) * 1.0f * 0.5f * f2;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123753_, entity.m_20185_() + (double)f3, entity.m_20186_(), entity.m_20189_() + (double)f4, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static Predicate<ItemEntity> pandaItems() {
        return itemEntity -> {
            ItemStack stack = itemEntity.m_32055_();
            return (stack.m_150930_(Blocks.f_50571_.m_5456_()) || stack.m_150930_(Blocks.f_50145_.m_5456_()) || Util.isCake().test(stack)) && itemEntity.m_6084_() && !itemEntity.m_32063_();
        };
    }

    public static Predicate<ItemStack> isCake() {
        return stack -> {
            for (Supplier<BaseCakeBlock> cake : CakeBuilder.BUILDER_BY_CAKE.keySet()) {
                if (!stack.m_150930_(cake.get().m_5456_())) continue;
                return true;
            }
            return false;
        };
    }

    public static <K, V> Map<K, V> createKeySortedMap(Map<K, V> map, Comparator<K> comparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static <K, V> Map<K, V> createValueSortedMap(Map<K, V> map, Comparator<V> comparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static LootTable.Builder addDropWhenCakeSpatulaPool(LootTable.Builder builder, Block block) {
        return builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_(HAS_CAKE_SPATULA)));
    }

    public static ImmutableList<Block> getVanillaCandleCakes() {
        return ImmutableList.of((Object)Blocks.f_152525_, (Object)Blocks.f_152526_, (Object)Blocks.f_152527_, (Object)Blocks.f_152528_, (Object)Blocks.f_152529_, (Object)Blocks.f_152530_, (Object)Blocks.f_152531_, (Object)Blocks.f_152532_, (Object)Blocks.f_152533_, (Object)Blocks.f_152534_, (Object)Blocks.f_152535_, (Object)Blocks.f_152536_, (Object[])new Block[]{Blocks.f_152485_, Blocks.f_152486_, Blocks.f_152487_, Blocks.f_152488_, Blocks.f_152489_});
    }
}

