/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.forge.common.packs;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.DoApi;
import de.cristelknight.doapi.forge.common.packs.BuiltinResourcePackSource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public class BuiltInPackRegistry {
    public static Map<ResourceLocation, Pair<PackResources, Boolean>> packResources = new HashMap<ResourceLocation, Pair<PackResources, Boolean>>();

    public static void getPacks(Consumer<Pack> consumer, boolean client) {
        if (packResources.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceLocation, Pair<PackResources, Boolean>> entry : packResources.entrySet()) {
            Pair<PackResources, Boolean> pair = entry.getValue();
            PackResources packResources = (PackResources)pair.getFirst();
            ResourceLocation id = entry.getKey();
            if (packResources == null) {
                DoApi.LOGGER.error("Pack for location: {} is null, skipping it!", (Object)id);
                continue;
            }
            if (client && packResources.m_5698_(PackType.CLIENT_RESOURCES).isEmpty()) {
                DoApi.LOGGER.debug(packResources.m_5542_() + " has no assets, skipping it!");
                continue;
            }
            if (!client && packResources.m_5698_(PackType.SERVER_DATA).isEmpty()) {
                DoApi.LOGGER.debug(packResources.m_5542_() + " has no data, skipping it!");
                continue;
            }
            Pack pack = Pack.m_245429_((String)packResources.m_5542_(), (Component)Component.m_237113_((String)(id.m_135827_() + "/" + id.m_135815_())), (boolean)((Boolean)pair.getSecond()), ignored -> packResources, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)new BuiltinResourcePackSource(id.m_135827_()));
            if (pack != null) {
                consumer.accept(pack);
                continue;
            }
            DoApi.LOGGER.error(packResources.m_5542_() + " couldn't be created");
        }
    }
}

