/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.block;

import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfy.bakery.registry.ObjectRegistry;
import satisfy.bakery.util.GeneralUtil;

public class BreadCrateBox
extends FacingBlock {
    public static final IntegerProperty CUTS = IntegerProperty.m_61631_((String)"cuts", (int)0, (int)4);
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.0625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.125, (double)0.8125, (double)0.5625, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.8125, (double)0.8125, (double)0.5625, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.1875, (double)0.1875, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0625, (double)0.1875, (double)0.875, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public BreadCrateBox(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CUTS, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            if (this.tryEat(world, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.tryEat(world, pos, state, player);
    }

    private InteractionResult tryEat(Level world, BlockPos pos, BlockState state, Player player) {
        world.m_5594_(null, pos, SoundEvents.f_11947_, SoundSource.PLAYERS, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        player.m_36324_().m_38707_(6, 0.8f);
        int cuts = (Integer)state.m_61143_((Property)CUTS);
        world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (cuts < 4) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CUTS, (Comparable)Integer.valueOf(cuts + 1)), 3);
        } else {
            world.m_46961_(pos, false);
            ItemStack bowlStack = new ItemStack((ItemLike)ObjectRegistry.TRAY.get());
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, bowlStack);
            world.m_7967_((Entity)itemEntity);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CUTS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.bakery.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.m_237115_((String)"block.bakery.breadcrate.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
    }
}

