/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.client.gui.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import satisfy.bakery.client.gui.handler.slot.ExtendedSlot;
import satisfy.bakery.client.gui.handler.slot.StoveOutputSlot;
import satisfy.bakery.client.recipebook.group.StoveRecipeBookGroup;
import satisfy.bakery.recipe.StoveRecipe;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.registry.ScreenHandlerTypeRegistry;

public class StoveGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    public static final int INPUTS = 4;
    public static final int FUEL_SLOT = 4;
    public static final int OUTPUT_SLOT = 0;

    public StoveGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(4));
    }

    public StoveGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData delegate) {
        super((MenuType)ScreenHandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), syncId, 4, playerInventory, inventory, delegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_(new StoveOutputSlot(playerInventory.f_35978_, inventory, 0, 126, 42));
        this.m_38897_(new ExtendedSlot(inventory, 1, 29, 18, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 2, 47, 18, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 3, 65, 18, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 4, 42, 48, StoveGuiHandler::isFuel));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean isIngredient(ItemStack stack) {
        return this.world.m_7465_().m_44013_((RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(x -> x.test(stack)));
    }

    private static boolean isFuel(ItemStack stack) {
        return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(2);
        int totalProgress = this.propertyDelegate.m_6413_(3);
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / totalProgress + 1;
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public List<IRecipeBookGroup> getGroups() {
        return StoveRecipeBookGroup.STOVE_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof StoveRecipe) {
            StoveRecipe StoveRecipe2 = (StoveRecipe)recipe;
            for (Ingredient ingredient : StoveRecipe2.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 4;
    }
}

