/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.compat.jei;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import satisfy.bakery.client.gui.handler.BakerStationGuiHandler;
import satisfy.bakery.client.gui.handler.StoveGuiHandler;
import satisfy.bakery.compat.jei.category.BakerStationCategory;
import satisfy.bakery.compat.jei.category.CookingPotCategory;
import satisfy.bakery.compat.jei.category.StoveCategory;
import satisfy.bakery.compat.jei.transfer.CookingTransferInfo;
import satisfy.bakery.registry.ObjectRegistry;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.registry.ScreenHandlerTypeRegistry;
import satisfy.bakery.util.BakeryIdentifier;

@JeiPlugin
public class BakeryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StoveCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BakerStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List fridgeRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        registration.addRecipes(CookingPotCategory.COOKING_POT, fridgeRecipes);
        List stoveRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get());
        registration.addRecipes(StoveCategory.STOVE, stoveRecipes);
        List bakerStationRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.BAKER_STATION_RECIPE_TYPE.get());
        registration.addRecipes(BakerStationCategory.BAKER_STATION, bakerStationRecipes);
    }

    public ResourceLocation getPluginUid() {
        return new BakeryIdentifier("jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.SMALL_COOKING_POT, CookingPotCategory.COOKING_POT);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.BAKER_STATION, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.BRICK_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.STONE_BRICKS_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.COBBLESTONE_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.DEEPSLATE_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.GRANITE_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.MUD_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.SANDSTONE_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.END_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.RED_NETHER_BRICKS_STOVE, BakerStationCategory.BAKER_STATION);
        BakeryJEIPlugin.addCatalyst(registration, ObjectRegistry.QUARTZ_STOVE, BakerStationCategory.BAKER_STATION);
    }

    private static void addCatalyst(IRecipeCatalystRegistration registration, RegistrySupplier<Block> block, RecipeType<?> ... recipeTypes) {
        registration.addRecipeCatalyst(((Block)block.get()).m_5456_().m_7968_(), recipeTypes);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingTransferInfo());
        registration.addRecipeTransferHandler(StoveGuiHandler.class, (MenuType)ScreenHandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), StoveCategory.STOVE, 1, 3, 5, 36);
        registration.addRecipeTransferHandler(BakerStationGuiHandler.class, (MenuType)ScreenHandlerTypeRegistry.BAKER_STATION_SCREEN_HANDLER.get(), BakerStationCategory.BAKER_STATION, 1, 2, 3, 36);
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

