/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import satisfy.bakery.client.gui.BakerStationGui;
import satisfy.bakery.compat.jei.BakeryJEIPlugin;
import satisfy.bakery.recipe.BakerStationRecipe;
import satisfy.bakery.registry.ObjectRegistry;

public class BakerStationCategory
implements IRecipeCategory<BakerStationRecipe> {
    public static final RecipeType<BakerStationRecipe> BAKER_STATION = RecipeType.create((String)"bakery", (String)"baker", BakerStationRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public BakerStationCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BakerStationGui.BG, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(BakerStationGui.BG, 177, 26, 22, 10).buildAnimated(50, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.BAKER_STATION.get()).m_5456_().m_7968_());
        this.localizedName = Component.m_237115_((String)"rei.bakery.baking_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BakerStationRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        BakeryJEIPlugin.addSlot(builder, 20, 14, (Ingredient)ingredients.get(0));
        BakeryJEIPlugin.addSlot(builder, 33, 30, (Ingredient)ingredients.get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 29).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(BakerStationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 68, 32);
    }

    public RecipeType<BakerStationRecipe> getRecipeType() {
        return BAKER_STATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

