/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import satisfy.bakery.client.gui.handler.BakerStationGuiHandler;
import satisfy.bakery.entity.ImplementedInventory;
import satisfy.bakery.recipe.BakerStationRecipe;
import satisfy.bakery.registry.BlockEntityRegistry;
import satisfy.bakery.registry.RecipeTypeRegistry;

public class BakerStationBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<BakerStationBlockEntity>,
MenuProvider {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    protected float experience;
    protected static final int[] UP_SLOT = new int[]{1};
    protected static final int[] SIDE_SLOT = new int[]{2};
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BakerStationBlockEntity.this.fermentationTime;
                case 1 -> BakerStationBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BakerStationBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    BakerStationBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    @Override
    public int[] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return UP_SLOT;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return new int[]{0};
        }
        return SIDE_SLOT;
    }

    public BakerStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BAKER_STATION_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128448_("FermentationTime");
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128350_("Experience", this.experience);
        nbt.m_128376_("FermentationTime", (short)this.fermentationTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, BakerStationBlockEntity blockEntity) {
        RegistryAccess access;
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        BakerStationRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.BAKER_STATION_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        if (this.canCraft(recipeType, access = this.f_58857_.m_9598_())) {
            ++this.fermentationTime;
            if (this.fermentationTime == this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType, access);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft(BakerStationRecipe recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        ItemStack itemStack = this.m_8020_(0);
        return itemStack.m_41619_() || itemStack == recipe.m_8043_(access);
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(BakerStationRecipe recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            ItemStack output = recipeOutput.m_41777_();
            this.m_6836_(0, output);
        }
        for (Ingredient entry : recipe.m_7527_()) {
            if (entry.test(this.m_8020_(1))) {
                this.m_7407_(1, 1);
            }
            if (!entry.test(this.m_8020_(2))) continue;
            this.m_7407_(2, 1);
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new BakerStationGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

