/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import satisfy.bakery.block.CookingPotBlock;
import satisfy.bakery.client.gui.handler.CookingPotGuiHandler;
import satisfy.bakery.entity.ImplementedInventory;
import satisfy.bakery.recipe.CookingPotRecipe;
import satisfy.bakery.registry.BlockEntityRegistry;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.registry.TagsRegistry;

public class CookingPotBlockEntity
extends BlockEntity
implements BlockEntityTicker<CookingPotBlockEntity>,
ImplementedInventory,
MenuProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private static final int MAX_CAPACITY = 8;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    protected static final int[] RECIPE_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    public static final int BOTTLE_INPUT_SLOT = 7;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 6;
    private boolean isBeingBurned;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CookingPotBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingPotBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPotBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingPotBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CookingPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.COOKING_POT_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return RECIPE_SLOTS;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return new int[]{0};
        }
        return new int[]{7};
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.m_58904_() == null) {
            throw new NullPointerException("Null world invoked");
        }
        BlockState belowState = this.m_58904_().m_8055_(this.m_58899_().m_7495_());
        if (belowState.m_204336_(TagsRegistry.ALLOWS_COOKING)) {
            try {
                return (Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
        return false;
    }

    private boolean canCraft(Recipe<?> recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingRecipe = (CookingPotRecipe)recipe;
            if (!this.m_8020_(7).m_150930_(cookingRecipe.getContainer().m_41720_())) {
                return false;
            }
            if (this.m_8020_(0).m_41619_()) {
                return true;
            }
            if (this.m_8020_(0).m_41619_()) {
                return true;
            }
            ItemStack recipeOutput = recipe.m_8043_(access);
            ItemStack outputSlotStack = this.m_8020_(0);
            int outputSlotCount = outputSlotStack.m_41613_();
            if (this.m_8020_(0).m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
                return false;
            }
            if (outputSlotCount < this.m_6893_() && outputSlotCount < outputSlotStack.m_41741_()) {
                return true;
            }
            return outputSlotCount < recipeOutput.m_41741_();
        }
        return false;
    }

    private void craft(Recipe<?> recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput.m_41777_());
        } else if (outputSlotStack.m_150930_(recipeOutput.m_41720_())) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        NonNullList ingredients = recipe.m_7527_();
        boolean[] slotUsed = new boolean[6];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ItemStack bestSlot;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.test(bestSlot = this.m_8020_(i)) && !slotUsed[i]) {
                slotUsed[i] = true;
                ItemStack remainderStack = this.getRemainderItem(bestSlot);
                bestSlot.m_41774_(1);
                if (remainderStack.m_41619_()) continue;
                this.m_6836_(i, remainderStack);
                continue;
            }
            for (int j = 0; j < 6; ++j) {
                ItemStack stack = this.m_8020_(j);
                if (!ingredient.test(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                ItemStack remainderStack = this.getRemainderItem(stack);
                stack.m_41774_(1);
                if (remainderStack.m_41619_()) continue;
                this.m_6836_(j, remainderStack);
            }
        }
        this.m_8020_(7).m_41774_(1);
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)stack.m_41720_().m_41469_());
        }
        return ItemStack.f_41583_;
    }

    public void tick(Level world, BlockPos pos, BlockState state, CookingPotBlockEntity blockEntity) {
        if (world.m_5776_()) {
            return;
        }
        boolean isBeingBurned = this.isBeingBurned();
        if (!isBeingBurned) {
            this.delegate.m_8050_(1, 0);
            if (((Boolean)state.m_61143_((Property)CookingPotBlock.LIT)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        this.delegate.m_8050_(1, 1);
        Recipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        RegistryAccess access = this.f_58857_.m_9598_();
        boolean canCraft = this.canCraft(recipe, access);
        if (canCraft) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe, access);
            }
        } else if (!this.canCraft(recipe, access)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.m_7731_(pos, (BlockState)((BlockState)this.m_58900_().m_60734_().m_49966_().m_61124_((Property)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.m_61143_((Property)CookingPotBlock.COOKING)).booleanValue()) {
            world.m_7731_(pos, (BlockState)((BlockState)this.m_58900_().m_60734_().m_49966_().m_61124_((Property)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if ((Boolean)state.m_61143_((Property)CookingPotBlock.LIT) != isBeingBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(isBeingBurned)), 3);
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new CookingPotGuiHandler(syncId, inv, (Container)this, this.delegate);
    }
}

