/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import satisfy.bakery.Bakery;
import satisfy.bakery.entity.BakerStationBlockEntity;
import satisfy.bakery.entity.CabinetBlockEntity;
import satisfy.bakery.entity.CookingPotBlockEntity;
import satisfy.bakery.entity.StoveBlockEntity;
import satisfy.bakery.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = BlockEntityRegistry.create("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CABINET.get(), (Block)ObjectRegistry.DRAWER.get(), (Block)ObjectRegistry.WALL_CABINET.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = BlockEntityRegistry.create("stove_block", () -> BlockEntityType.Builder.m_155273_(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BRICK_STOVE.get(), (Block)ObjectRegistry.COBBLESTONE_STOVE.get(), (Block)ObjectRegistry.MUD_STOVE.get(), (Block)ObjectRegistry.GRANITE_STOVE.get(), (Block)ObjectRegistry.SANDSTONE_STOVE.get(), (Block)ObjectRegistry.STONE_BRICKS_STOVE.get(), (Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get(), (Block)ObjectRegistry.DEEPSLATE_STOVE.get(), (Block)ObjectRegistry.QUARTZ_STOVE.get(), (Block)ObjectRegistry.END_STOVE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CookingPotBlockEntity>> COOKING_POT_BLOCK_ENTITY = BlockEntityRegistry.create("cooking_pot", () -> BlockEntityType.Builder.m_155273_(CookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SMALL_COOKING_POT.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BakerStationBlockEntity>> BAKER_STATION_BLOCK_ENTITY = BlockEntityRegistry.create("baker_station", () -> BlockEntityType.Builder.m_155273_(BakerStationBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BAKER_STATION.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Bakery.LOGGER.debug("Registering Mod BlockEntities for bakery");
        BLOCK_ENTITY_TYPES.register();
    }
}

