/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import satisfy.bakery.Bakery;
import satisfy.bakery.effect.BakeryEffect;
import satisfy.bakery.effect.SaturatedEffect;
import satisfy.bakery.util.BakeryIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> STUFFED = EffectRegistry.registerEffect("stuffed", SaturatedEffect::new);
    public static final RegistrySupplier<MobEffect> SWEETS = EffectRegistry.registerEffect("sweets", () -> new BakeryEffect(MobEffectCategory.BENEFICIAL, 65280).m_19472_(Attributes.f_22279_, "812EA0BC-B71A-AF17-836C-1E5F68070C46", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22283_, "1238C173-3FC1-6C89-408D-5F62AB9DCF03", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22281_, "A75D3FB4-6BB0-92D9-8C26-C2600A6C4929", 0.0, AttributeModifier.Operation.ADDITION));

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new BakeryIdentifier(name), effect);
    }

    public static void init() {
        Bakery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }
}

