/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.registry;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.ChairBlock;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import satisfy.bakery.block.BakerStationBlock;
import satisfy.bakery.block.BoardBlock;
import satisfy.bakery.block.BreadBox;
import satisfy.bakery.block.BreadCrateBox;
import satisfy.bakery.block.CabinetBlock;
import satisfy.bakery.block.CabinetWallBlock;
import satisfy.bakery.block.CakeStandBlock;
import satisfy.bakery.block.ChocolateBoxBlock;
import satisfy.bakery.block.CookingPotBlock;
import satisfy.bakery.block.CounterBlock;
import satisfy.bakery.block.KitchenSinkBlock;
import satisfy.bakery.block.StackableBlock;
import satisfy.bakery.block.StackableBunBlock;
import satisfy.bakery.block.StoveBlock;
import satisfy.bakery.block.TableBlock;
import satisfy.bakery.block.TrayBlock;
import satisfy.bakery.block.cakes.ApplePieBlock;
import satisfy.bakery.block.cakes.BundtCakeBlock;
import satisfy.bakery.block.cakes.CakeBlock;
import satisfy.bakery.block.cakes.ChocolateTart;
import satisfy.bakery.block.cakes.GlowberryTartBlock;
import satisfy.bakery.block.cakes.LinzerTartBlock;
import satisfy.bakery.block.cakes.PuddingBlock;
import satisfy.bakery.block.crops.OatCropBlock;
import satisfy.bakery.block.crops.StrawberryCropBlock;
import satisfy.bakery.block.crops.WildBush;
import satisfy.bakery.item.FoodBlockItem;
import satisfy.bakery.item.IndulgentDelightItem;
import satisfy.bakery.item.SaturatedItem;
import satisfy.bakery.item.SweetlySatiatedItem;
import satisfy.bakery.item.SweetsItem;
import satisfy.bakery.item.TooltipItem;
import satisfy.bakery.registry.EffectRegistry;
import satisfy.bakery.registry.EntityRegistry;
import satisfy.bakery.registry.SoundEventRegistry;
import satisfy.bakery.util.BakeryIdentifier;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> STRAWBERRY_TAIGA = ObjectRegistry.registerWithoutItem("strawberry_taiga", () -> new WildBush(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Block> STRAWBERRY_JUNGLE = ObjectRegistry.registerWithoutItem("strawberry_jungle", () -> new WildBush(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Block> STRAWBERRY_CROP = ObjectRegistry.registerWithoutItem("strawberry_crop", () -> new StrawberryCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Item> STRAWBERRY_SEEDS = ObjectRegistry.registerItem("strawberry_seeds", () -> new BlockItem((Block)STRAWBERRY_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> STRAWBERRY = ObjectRegistry.registerItem("strawberry", () -> new TooltipItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38813_)));
    public static final RegistrySupplier<Block> OAT_CROP = ObjectRegistry.registerWithoutItem("oat_crop", () -> new OatCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_)));
    public static final RegistrySupplier<Item> OAT_SEEDS = ObjectRegistry.registerItem("oat_seeds", () -> new BlockItem((Block)OAT_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> OAT = ObjectRegistry.registerItem("oat", () -> new TooltipItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38813_)));
    public static final RegistrySupplier<Block> STRAWBERRY_CRATE = ObjectRegistry.registerWithItem("strawberry_crate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> OAT_CRATE = ObjectRegistry.registerWithItem("oat_crate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> OAT_BLOCK = ObjectRegistry.registerWithItem("oat_block", () -> new HayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56740_)));
    public static final RegistrySupplier<Block> OAT_STAIRS = ObjectRegistry.registerWithItem("oat_stairs", () -> new StairBlock(Blocks.f_50705_.m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60918_(SoundType.f_56740_)));
    public static final RegistrySupplier<Block> OAT_SLAB = ObjectRegistry.registerWithItem("oat_slab", () -> new SlabBlock(ObjectRegistry.getSlabSettings().m_60918_(SoundType.f_56740_)));
    public static final RegistrySupplier<Block> KITCHEN_SINK = ObjectRegistry.registerWithItem("kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60955_()));
    public static final RegistrySupplier<Block> BRICK_STOVE = ObjectRegistry.registerWithItem("brick_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> BAKER_STATION = ObjectRegistry.registerWithItem("baker_station", () -> new BakerStationBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_)));
    public static final RegistrySupplier<Block> BRICK_COUNTER = ObjectRegistry.registerWithItem("brick_counter", () -> new CounterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_)));
    public static final RegistrySupplier<Block> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), SoundEventRegistry.BLOCK_CABINET_OPEN, SoundEventRegistry.BLOCK_CABINET_CLOSE));
    public static final RegistrySupplier<Block> DRAWER = ObjectRegistry.registerWithItem("drawer", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), SoundEventRegistry.BLOCK_CABINET_OPEN, SoundEventRegistry.BLOCK_CABINET_CLOSE));
    public static final RegistrySupplier<Block> WALL_CABINET = ObjectRegistry.registerWithItem("wall_cabinet", () -> new CabinetWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), SoundEventRegistry.BLOCK_CABINET_OPEN, SoundEventRegistry.BLOCK_CABINET_CLOSE));
    public static final RegistrySupplier<Block> IRON_CHAIR = ObjectRegistry.registerWithItem("iron_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistrySupplier<Block> IRON_TABLE = ObjectRegistry.registerWithItem("iron_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> STREET_SIGN = ObjectRegistry.registerWithItem("street_sign", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), true));
    public static final RegistrySupplier<Block> CAKE_STAND = ObjectRegistry.registerWithItem("cake_stand", () -> new CakeStandBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_).m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> BREADBOX = ObjectRegistry.registerWithItem("breadbox", () -> new BreadBox(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> TRAY = ObjectRegistry.registerWithItem("tray", () -> new TrayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> BREAD_CRATE = ObjectRegistry.registerWithItem("bread_crate", () -> new BreadCrateBox(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> CHOCOLATE_BOX = ObjectRegistry.registerWithItem("chocolate_box", () -> new ChocolateBoxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> ROLLING_PIN = ObjectRegistry.registerItem("rolling_pin", () -> new SwordItem((Tier)Tiers.WOOD, 1, -2.0f, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BREAD_KNIFE = ObjectRegistry.registerItem("bread_knife", () -> new SwordItem((Tier)Tiers.IRON, 1, -2.0f, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Block> SMALL_COOKING_POT = ObjectRegistry.registerWithItem("small_cooking_pot", () -> new CookingPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_()));
    public static final RegistrySupplier<Block> JAR = ObjectRegistry.registerWithItem("jar", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60955_().m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> STRAWBERRY_JAM = ObjectRegistry.registerWithItem("strawberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60955_().m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> GLOWBERRY_JAM = ObjectRegistry.registerWithItem("glowberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60955_().m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> SWEETBERRY_JAM = ObjectRegistry.registerWithItem("sweetberry_jam", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60955_().m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> CHOCOLATE_JAM = ObjectRegistry.registerWithItem("chocolate_jam", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60955_().m_60918_(SoundType.f_56744_)));
    public static final RegistrySupplier<Block> APPLE_JAM = ObjectRegistry.registerWithItem("apple_jam", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60966_().m_60918_(SoundType.f_56744_).m_60955_()));
    public static final RegistrySupplier<Item> YEAST = ObjectRegistry.registerItem("yeast", () -> new IndulgentDelightItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38804_), 100));
    public static final RegistrySupplier<Item> DOUGH = ObjectRegistry.registerItem("dough", () -> new IndulgentDelightItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38804_), 100));
    public static final RegistrySupplier<Item> SWEET_DOUGH = ObjectRegistry.registerItem("sweet_dough", () -> new IndulgentDelightItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38804_), 100));
    public static final RegistrySupplier<Item> CROISSANT = ObjectRegistry.registerItem("croissant", () -> new SweetsItem(ObjectRegistry.getFoodItemSettings(5, 0.6f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 400));
    public static final RegistrySupplier<Block> CRUSTY_BREAD_BLOCK = ObjectRegistry.registerWithoutItem("crusty_bread_block", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> CRUSTY_BREAD = ObjectRegistry.registerItem("crusty_bread", () -> new FoodBlockItem((Block)CRUSTY_BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 4800)));
    public static final RegistrySupplier<Block> BREAD_BLOCK = ObjectRegistry.registerWithoutItem("bread_block", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> BREAD = ObjectRegistry.registerItem("bread", () -> new FoodBlockItem((Block)BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 4200)));
    public static final RegistrySupplier<Block> BAGUETTE_BLOCK = ObjectRegistry.registerWithoutItem("baguette_block", () -> new StackableBunBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> BAGUETTE = ObjectRegistry.registerItem("baguette", () -> new FoodBlockItem((Block)BAGUETTE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 4200)));
    public static final RegistrySupplier<Block> TOAST_BLOCK = ObjectRegistry.registerWithoutItem("toast_block", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> TOAST = ObjectRegistry.registerItem("toast", () -> new FoodBlockItem((Block)TOAST_BLOCK.get(), ObjectRegistry.getFoodItemSettings(3, 0.8f, (MobEffect)EffectRegistry.STUFFED.get(), 5400)));
    public static final RegistrySupplier<Block> BRAIDED_BREAD_BLOCK = ObjectRegistry.registerWithoutItem("braided_bread_block", () -> new StackableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> BRAIDED_BREAD = ObjectRegistry.registerItem("braided_bread", () -> new FoodBlockItem((Block)BRAIDED_BREAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 4200)));
    public static final RegistrySupplier<Block> BUN_BLOCK = ObjectRegistry.registerWithoutItem("bun_block", () -> new StackableBunBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> BUN = ObjectRegistry.registerItem("bun", () -> new FoodBlockItem((Block)BUN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 2800)));
    public static final RegistrySupplier<Item> VEGETABLE_SANDWICH = ObjectRegistry.registerItem("vegetable_sandwich", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(3, 0.8f, (MobEffect)EffectRegistry.STUFFED.get(), 4800)));
    public static final RegistrySupplier<Item> SANDWICH = ObjectRegistry.registerItem("sandwich", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(6, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 6000)));
    public static final RegistrySupplier<Item> STRAWBERRY_CAKE_SLICE = ObjectRegistry.registerItem("strawberry_cake_slice", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_), 700));
    public static final RegistrySupplier<Item> SWEETBERRY_CAKE_SLICE = ObjectRegistry.registerItem("sweetberry_cake_slice", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_), 700));
    public static final RegistrySupplier<Item> CHOCOLATE_CAKE_SLICE = ObjectRegistry.registerItem("chocolate_cake_slice", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_), 700));
    public static final RegistrySupplier<Item> PUDDING_SLICE = ObjectRegistry.registerItem("pudding_slice", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_), 700));
    public static final RegistrySupplier<Item> BUNDT_CAKE_SLICE = ObjectRegistry.registerItem("bundt_cake_slice", () -> new SweetlySatiatedItem(ObjectRegistry.getFoodItemSettings(5, 1.4f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 800));
    public static final RegistrySupplier<Item> LINZER_TART_SLICE = ObjectRegistry.registerItem("linzer_tart_slice", () -> new SweetlySatiatedItem(ObjectRegistry.getFoodItemSettings(5, 1.4f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 800));
    public static final RegistrySupplier<Item> APPLE_PIE_SLICE = ObjectRegistry.registerItem("apple_pie_slice", () -> new SweetlySatiatedItem(ObjectRegistry.getFoodItemSettings(5, 1.4f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 800));
    public static final RegistrySupplier<Item> GLOWBERRY_PIE_SLICE = ObjectRegistry.registerItem("glowberry_pie_slice", () -> new SweetlySatiatedItem(ObjectRegistry.getFoodItemSettings(5, 1.4f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 800));
    public static final RegistrySupplier<Item> CHOCOLATE_TART_SLICE = ObjectRegistry.registerItem("chocolate_tart_slice", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_), 700));
    public static final RegistrySupplier<Block> STRAWBERRY_CAKE = ObjectRegistry.registerWithItem("strawberry_cake", () -> new CakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)STRAWBERRY_CAKE_SLICE));
    public static final RegistrySupplier<Block> SWEETBERRY_CAKE = ObjectRegistry.registerWithItem("sweetberry_cake", () -> new CakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)SWEETBERRY_CAKE_SLICE));
    public static final RegistrySupplier<Block> CHOCOLATE_CAKE = ObjectRegistry.registerWithItem("chocolate_cake", () -> new CakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)CHOCOLATE_CAKE_SLICE));
    public static final RegistrySupplier<Block> PUDDING = ObjectRegistry.registerWithItem("pudding", () -> new PuddingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)PUDDING_SLICE));
    public static final RegistrySupplier<Block> BUNDT_CAKE = ObjectRegistry.registerWithItem("bundt_cake", () -> new BundtCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)BUNDT_CAKE_SLICE));
    public static final RegistrySupplier<Block> LINZER_TART = ObjectRegistry.registerWithItem("linzer_tart", () -> new LinzerTartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)LINZER_TART_SLICE));
    public static final RegistrySupplier<Block> APPLE_PIE = ObjectRegistry.registerWithItem("apple_pie", () -> new ApplePieBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)APPLE_PIE_SLICE));
    public static final RegistrySupplier<Block> GLOWBERRY_TART = ObjectRegistry.registerWithItem("glowberry_tart", () -> new GlowberryTartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)GLOWBERRY_PIE_SLICE));
    public static final RegistrySupplier<Block> CHOCOLATE_TART = ObjectRegistry.registerWithItem("chocolate_tart", () -> new ChocolateTart(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)CHOCOLATE_TART_SLICE));
    public static final RegistrySupplier<Item> STRAWBERRY_GLAZED_COOKIE = ObjectRegistry.registerItem("strawberry_glazed_cookie", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 300));
    public static final RegistrySupplier<Item> SWEETBERRY_GLAZED_COOKIE = ObjectRegistry.registerItem("sweetberry_glazed_cookie", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 300));
    public static final RegistrySupplier<Item> CHOCOLATE_GLAZED_COOKIE = ObjectRegistry.registerItem("chocolate_glazed_cookie", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 300));
    public static final RegistrySupplier<Item> STRAWBERRY_CUPCAKE = ObjectRegistry.registerItem("strawberry_cupcake", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 500));
    public static final RegistrySupplier<Item> SWEETBERRY_CUPCAKE = ObjectRegistry.registerItem("sweetberry_cupcake", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 500));
    public static final RegistrySupplier<Item> APPLE_CUPCAKE = ObjectRegistry.registerItem("apple_cupcake", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_), 500));
    public static final RegistrySupplier<Item> JAM_ROLL = ObjectRegistry.registerItem("jam_roll", () -> new SweetlySatiatedItem(ObjectRegistry.getFoodItemSettings(4, 0.7f, (MobEffect)EffectRegistry.STUFFED.get(), 900), 800));
    public static final RegistrySupplier<Block> WAFFLE_BLOCK = ObjectRegistry.registerWithoutItem("waffle_block", () -> new StackableBunBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> WAFFLE = ObjectRegistry.registerItem("waffle", () -> new FoodBlockItem((Block)WAFFLE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(5, 1.2f, (MobEffect)EffectRegistry.STUFFED.get(), 800)));
    public static final RegistrySupplier<Item> CHOCOLATE_TRUFFLE = ObjectRegistry.registerItem("chocolate_truffle", () -> new SweetsItem(ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.4f).m_38766_().m_38767_()), 200));
    public static final RegistrySupplier<Block> COBBLESTONE_STOVE = ObjectRegistry.registerWithItem("cobblestone_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> SANDSTONE_STOVE = ObjectRegistry.registerWithItem("sandstone_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> STONE_BRICKS_STOVE = ObjectRegistry.registerWithItem("stone_bricks_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> DEEPSLATE_STOVE = ObjectRegistry.registerWithItem("deepslate_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> GRANITE_STOVE = ObjectRegistry.registerWithItem("granite_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> END_STOVE = ObjectRegistry.registerWithItem("end_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> MUD_STOVE = ObjectRegistry.registerWithItem("mud_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> QUARTZ_STOVE = ObjectRegistry.registerWithItem("quartz_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Block> RED_NETHER_BRICKS_STOVE = ObjectRegistry.registerWithItem("red_nether_bricks_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0)));
    public static final RegistrySupplier<Item> BLANK_CAKE = ObjectRegistry.registerItem("blank_cake", () -> new Item(ObjectRegistry.getSettingsWithoutTab().m_41489_(Foods.f_38804_)));
    public static final RegistrySupplier<Item> WANDERING_BAKER_SPAWN_EGG = ObjectRegistry.registerItem("wandering_baker_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.WANDERING_BAKER, -1, -1, ObjectRegistry.getSettingsWithoutTab()));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettingsWithoutTab(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getSettingsWithoutTab() {
        return ObjectRegistry.getSettingsWithoutTab(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BakeryIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new BakeryIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BakeryIdentifier(path), itemSupplier);
    }

    private static BlockBehaviour.Properties getBushSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_);
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, MobEffect effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(nutrition, saturationMod, effect, duration, false, false);
    }

    private static Item.Properties getFoodItemSettings(int nutrition, float saturationMod, MobEffect effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().m_41489_(ObjectRegistry.createFood(nutrition, saturationMod, effect, duration, alwaysEat, fast));
    }

    private static FoodProperties createFood(int nutrition, float saturationMod, MobEffect effect, int duration, boolean alwaysEat, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationMod);
        if (alwaysEat) {
            food.m_38765_();
        }
        if (fast) {
            food.m_38766_();
        }
        if (effect != null) {
            food.m_38762_(new MobEffectInstance(effect, duration), 1.0f);
        }
        return food.m_38767_();
    }

    private static BlockBehaviour.Properties getLogBlockSettings() {
        return BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    private static BlockBehaviour.Properties getSlabSettings() {
        return ObjectRegistry.getLogBlockSettings().m_155956_(3.0f);
    }
}

