/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GeneralUtil {
    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static boolean isFullAndSolid(LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFaceFull(levelReader, blockPos) && GeneralUtil.isSolid(levelReader, blockPos);
    }

    public static boolean isFaceFull(LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_7495_();
        return Block.m_49918_((VoxelShape)levelReader.m_8055_(belowPos).m_60808_((BlockGetter)levelReader, belowPos), (Direction)Direction.UP);
    }

    public static void spawnSlice(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.m_20334_(xMotion, yMotion, zMotion);
        level.m_7967_((Entity)entity);
    }

    public static boolean isSolid(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_280296_();
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static boolean matchesRecipe(Container inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            validStacks.add(stackInSlot);
        }
        for (Ingredient entry : recipe) {
            boolean matches = false;
            for (ItemStack item : validStacks) {
                if (!entry.test(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

