/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.block;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfyu.candlelight.registry.ObjectRegistry;
import satisfyu.candlelight.registry.StorageTypesRegistry;
import satisfyu.candlelight.util.CandlelightGeneralUtil;

public class TableSetBlock
extends StorageBlock {
    public static final EnumProperty<PlateType> PLATE_TYPE = EnumProperty.m_61587_((String)"plate", PlateType.class);
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, CandlelightGeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public TableSetBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)super.m_49966_().m_61124_(PLATE_TYPE, (Comparable)((Object)PlateType.PLATE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        PlateType type = (PlateType)((Object)state.m_61143_(PLATE_TYPE));
        if (stack.m_41619_() && player.m_6144_()) {
            world.m_46953_(pos, true, (Entity)player);
        } else {
            if (type == PlateType.ALL) {
                return super.m_6227_(state, world, pos, player, hand, hit);
            }
            if (type != PlateType.GLASS && item.equals(ObjectRegistry.GLASS.get())) {
                if (!world.m_5776_()) {
                    if (type == PlateType.PLATE) {
                        world.m_46597_(pos, (BlockState)state.m_61124_(PLATE_TYPE, (Comparable)((Object)PlateType.GLASS)));
                    } else {
                        world.m_46597_(pos, (BlockState)state.m_61124_(PLATE_TYPE, (Comparable)((Object)PlateType.ALL)));
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (type != PlateType.NAPKIN && item.equals(ObjectRegistry.NAPKIN.get())) {
                if (!world.m_5776_()) {
                    if (type == PlateType.PLATE) {
                        world.m_46597_(pos, (BlockState)state.m_61124_(PLATE_TYPE, (Comparable)((Object)PlateType.NAPKIN)));
                    } else {
                        world.m_46597_(pos, (BlockState)state.m_61124_(PLATE_TYPE, (Comparable)((Object)PlateType.ALL)));
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void remove(Level world, BlockPos blockPos, Player player, StorageBlockEntity shelfBlockEntity, int i) {
        if (!world.m_5776_()) {
            ItemStack itemStack = shelfBlockEntity.removeStack(i);
            SoundEvent soundEvent = SoundEvents.f_11912_;
            world.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemStack.m_41614_()) {
                FoodProperties foodComponent = itemStack.m_41720_().m_41473_();
                player.m_36324_().m_38707_(Math.round((float)foodComponent.m_38744_() * 1.3f), foodComponent.m_38745_() * 1.3f);
                List list = foodComponent.m_38749_();
                for (Pair pair : list) {
                    if (pair.getFirst() == null || !(world.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
            }
        }
    }

    public int size() {
        return 1;
    }

    public ResourceLocation type() {
        return StorageTypesRegistry.TABLE_SET;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41614_();
    }

    public int getSection(Float x, Float y) {
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PLATE_TYPE});
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        Direction direction = Direction.UP;
        return Block.m_49918_((VoxelShape)shape, (Direction)direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.candlelight.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.m_237115_((String)"block.candlelight.table_set.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        tooltip.add((Component)Component.m_237115_((String)"block.candlelight.table_set2.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
    }

    private static enum PlateType implements StringRepresentable
    {
        PLATE("plate"),
        GLASS("glass"),
        NAPKIN("napkin"),
        ALL("all");

        private final String name;

        private PlateType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

