/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.client.recipebook.custom;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfyu.candlelight.item.food.EffectFoodItem;
import satisfyu.candlelight.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum CookingPotRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    EFFECT(new ItemStack((ItemLike)Items.f_42589_)),
    MISC(new ItemStack((ItemLike)ObjectRegistry.DOUGH.get())),
    BIG(new ItemStack((ItemLike)ObjectRegistry.LASAGNA.get()));

    public static final List<IRecipeBookGroup> POT_GROUPS;
    private final List<ItemStack> icons;

    private CookingPotRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<? extends Container> recipe, RegistryAccess registryAccess) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SEARCH -> true;
            case MISC -> {
                if (recipe.m_7527_().stream().noneMatch(ingredient -> ingredient.test(Items.f_42589_.m_7968_())) && recipe.m_7527_().stream().noneMatch(ingredient -> Arrays.stream(ingredient.m_43908_()).anyMatch(itemStack -> itemStack.m_41720_() instanceof EffectFoodItem))) {
                    yield true;
                }
                yield false;
            }
            case EFFECT -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(Items.f_42589_.m_7968_()));
            case BIG -> recipe.m_7527_().stream().anyMatch(ingredient -> Arrays.stream(ingredient.m_43908_()).anyMatch(itemStack -> itemStack.m_41720_() instanceof EffectFoodItem));
        };
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        POT_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)MISC), (Object)((Object)EFFECT), (Object)((Object)BIG));
    }
}

