/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.compat.jei;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import satisfyu.candlelight.compat.jei.category.CookingPanCategory;
import satisfyu.candlelight.compat.jei.category.CookingPotCategory;
import satisfyu.candlelight.compat.jei.transfer.CookingPanTransferInfo;
import satisfyu.candlelight.compat.jei.transfer.CookingPotTransferInfo;
import satisfyu.candlelight.registry.ObjectRegistry;
import satisfyu.candlelight.registry.RecipeTypeRegistry;
import satisfyu.candlelight.util.CandlelightIdentifier;

@JeiPlugin
public class CandlelightJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPanCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List cookingPotRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        registration.addRecipes(CookingPotCategory.COOKING_POT, cookingPotRecipes);
        List cookingPanRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COOKING_PAN_RECIPE_TYPE.get());
        registration.addRecipes(CookingPanCategory.COOKING_PAN, cookingPanRecipes);
    }

    public ResourceLocation getPluginUid() {
        return new CandlelightIdentifier("jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        CandlelightJEIPlugin.addCatalyst(registration, ObjectRegistry.COOKING_POT, CookingPotCategory.COOKING_POT);
        CandlelightJEIPlugin.addCatalyst(registration, ObjectRegistry.COOKING_PAN, CookingPanCategory.COOKING_PAN);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingPotTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingPanTransferInfo());
    }

    private static void addCatalyst(IRecipeCatalystRegistration registration, RegistrySupplier<Block> block, RecipeType<?> ... recipeTypes) {
        registration.addRecipeCatalyst(((Block)block.get()).m_5456_().m_7968_(), recipeTypes);
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

