/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import satisfyu.candlelight.client.gui.CookingPanGui;
import satisfyu.candlelight.compat.jei.CandlelightJEIPlugin;
import satisfyu.candlelight.recipe.CookingPanRecipe;
import satisfyu.candlelight.registry.ObjectRegistry;

public class CookingPanCategory
implements IRecipeCategory<CookingPanRecipe> {
    public static final RecipeType<CookingPanRecipe> COOKING_PAN = RecipeType.create((String)"candlelight", (String)"pan_cooking", CookingPanRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public CookingPanCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(CookingPanGui.BACKGROUND, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(CookingPanGui.BACKGROUND, 178, 15, 23, 30).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.COOKING_PAN.get()).m_5456_().m_7968_());
        this.burnIcon = helper.createDrawable(CookingPanGui.BACKGROUND, 176, 0, 17, 15);
        this.localizedName = Component.m_237115_((String)"rei.candlelight.cooking_pan_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingPanRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        builder.addSlot(RecipeIngredientRole.INPUT, 69, 42).addItemStack(recipe.getContainer());
        for (int row = 0; row < 2; ++row) {
            int current;
            for (int slot = 0; slot < 3 && s - 1 >= (current = slot + row + row * 2); ++slot) {
                CandlelightJEIPlugin.addSlot(builder, 30 + slot * 18 - 26, 17 + row * 18 - 13, (Ingredient)ingredients.get(current));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 15).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(CookingPanRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 69, 1);
        this.burnIcon.draw(guiGraphics, 98, 43);
    }

    public RecipeType<CookingPanRecipe> getRecipeType() {
        return COOKING_PAN;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

