/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import satisfyu.candlelight.registry.RecipeTypeRegistry;
import satisfyu.candlelight.util.CandlelightGeneralUtil;

public class CookingPotRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack container;
    private final ItemStack output;

    public CookingPotRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack container, ItemStack output) {
        this.id = id;
        this.inputs = inputs;
        this.container = container;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return CandlelightGeneralUtil.matchesRecipe(inventory, this.inputs, 0, 6);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.COOKING_POT_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CookingPotRecipe> {
        public CookingPotRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = CandlelightGeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingPot Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingPot Recipe");
            }
            return new CookingPotRecipe(id, ingredients, ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container")), ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")));
        }

        public CookingPotRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            return new CookingPotRecipe(id, (NonNullList<Ingredient>)ingredients, buf.m_130267_(), buf.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buf, CookingPotRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.getContainer());
            buf.m_130055_(recipe.output);
        }
    }
}

