/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import satisfyu.candlelight.Candlelight;
import satisfyu.candlelight.entity.CookingPanBlockEntity;
import satisfyu.candlelight.entity.CookingPotBlockEntity;
import satisfyu.candlelight.entity.EffectFoodBlockEntity;
import satisfyu.candlelight.entity.SideBoardBlockEntity;
import satisfyu.candlelight.entity.StorageBlockEntity;
import satisfyu.candlelight.entity.TypeWriterEntity;
import satisfyu.candlelight.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_BLOCK_ENTITY = BlockEntityRegistry.create("storage_block", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.OAK_CABINET.get(), (Block)ObjectRegistry.OAK_DRAWER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CookingPotBlockEntity>> COOKING_POT_BLOCK_ENTITY = BlockEntityRegistry.create("cooking_pot", () -> BlockEntityType.Builder.m_155273_(CookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_POT.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<SideBoardBlockEntity>> SIDEBOARD = BlockEntityRegistry.create("sideboard", () -> BlockEntityType.Builder.m_155273_(SideBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SIDEBOARD.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<TypeWriterEntity>> TYPE_WRITER_BLOCK_ENTITY = BlockEntityRegistry.create("type_writer", () -> BlockEntityType.Builder.m_155273_(TypeWriterEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TYPEWRITER_IRON.get(), (Block)ObjectRegistry.TYPEWRITER_COPPER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CookingPanBlockEntity>> COOKING_PAN_BLOCK_ENTITY = BlockEntityRegistry.create("cooking_pan", () -> BlockEntityType.Builder.m_155273_(CookingPanBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_PAN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<EffectFoodBlockEntity>> EFFECT_FOOD_BLOCK_ENTITY = BlockEntityRegistry.create("effect_food_block", () -> BlockEntityType.Builder.m_155273_(EffectFoodBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LASAGNA_BLOCK.get(), (Block)ObjectRegistry.TOMATO_MOZZARELLA_BLOCK.get(), (Block)ObjectRegistry.PORK_RIBS_BLOCK.get(), (Block)ObjectRegistry.BROCCOLI_TOMATO_BLOCK.get(), (Block)ObjectRegistry.BEEF_WELLINGTON_BLOCK.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Candlelight.LOGGER.debug("Registering Mod BlockEntities for candlelight");
        BLOCK_ENTITY_TYPES.register();
    }
}

