/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandlelightGeneralUtil {
    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return CandlelightGeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static boolean isFullAndSolid(LevelReader levelReader, BlockPos blockPos) {
        return CandlelightGeneralUtil.isFaceFull(levelReader, blockPos) && CandlelightGeneralUtil.isSolid(levelReader, blockPos);
    }

    public static boolean isFaceFull(LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_7495_();
        return Block.m_49918_((VoxelShape)levelReader.m_8055_(belowPos).m_60808_((BlockGetter)levelReader, belowPos), (Direction)Direction.UP);
    }

    public static boolean isSolid(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_280296_();
    }

    public static ItemStack convertStackAfterFinishUsing(LivingEntity entity, ItemStack used, Item returnItem, Item usedItem) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, used);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)usedItem));
        }
        if (used.m_41619_()) {
            return new ItemStack((ItemLike)returnItem);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Player)entity).m_150110_().f_35937_) {
                ItemStack itemStack2 = new ItemStack((ItemLike)returnItem);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static InteractionResult fillBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(blockPos, blockState);
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult emptyBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(blockPos, blockState);
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static boolean matchesRecipe(Container inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            validStacks.add(stackInSlot);
        }
        for (Ingredient entry : recipe) {
            boolean matches = false;
            for (ItemStack item : validStacks) {
                if (!entry.test(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

