/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfyu.meadow.block.MeadowBlockProperties;
import net.satisfyu.meadow.block.ShutterType;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<ShutterType> TYPE = MeadowBlockProperties.SHUTTER_TYPE;
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0)};

    public ShutterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)ShutterType.NONE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_() + (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() ? (((Boolean)state.m_61143_((Property)LEFT)).booleanValue() ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean left;
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Vec3 clickLocation = context.m_43720_();
        if (facing.m_122434_() == Direction.Axis.X) {
            left = clickLocation.f_82481_ - (double)clickedPos.m_123343_() > 0.5;
        } else {
            boolean bl = left = clickLocation.f_82479_ - (double)clickedPos.m_123341_() > 0.5;
        }
        if (context.m_7820_() == Direction.NORTH || context.m_7820_() == Direction.EAST) {
            left = !left;
        }
        blockState = (BlockState)blockState.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left));
        if (world.m_276867_(clickedPos)) {
            blockState = (BlockState)((BlockState)blockState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_7494_()), world.m_8055_(clickedPos.m_7495_()))));
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        boolean powered = world.m_276867_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)OPEN) != powered) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                world.m_5594_(null, pos, ShutterBlock.shutterSound(powered), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
        }
        ShutterType type = this.getType(state, world.m_8055_(pos.m_7494_()), world.m_8055_(pos.m_7495_()));
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.toggleShutters(state, level, pos, player);
    }

    public InteractionResult toggleShutters(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 3);
        if (player == null || !player.m_6047_()) {
            this.toggleShutters(state, level, pos, (Boolean)state.m_61143_((Property)OPEN));
        }
        level.m_5594_(null, pos, ShutterBlock.shutterSound((Boolean)state.m_61143_((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void toggleShutters(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.m_61143_(TYPE) == ShutterType.MIDDLE || state.m_61143_(TYPE) == ShutterType.BOTTOM) {
            BlockState above;
            int heightUp = level.m_6042_().f_156648_() - updatePos.m_123342_();
            for (i = 0; i < heightUp && (above = level.m_8055_(updatePos.m_7494_())).m_60713_(state.m_60734_()) && above.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && above.m_61143_((Property)LEFT) == updateState.m_61143_((Property)LEFT) && (Boolean)above.m_61143_((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.m_7494_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.m_61143_(TYPE) == ShutterType.MIDDLE || state.m_61143_(TYPE) == ShutterType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.m_6042_().f_156647_() - updatePos.m_123342_();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.m_8055_(updatePos.m_7495_())).m_60713_(state.m_60734_()) && below.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && below.m_61143_((Property)LEFT) == updateState.m_61143_((Property)LEFT) && (Boolean)below.m_61143_((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.m_7495_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent shutterSound(boolean open) {
        if (open) {
            return SoundEvents.f_243707_;
        }
        return SoundEvents.f_244543_;
    }

    public ShutterType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.m_60734_() == state.m_60734_() && above.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && above.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN) && above.m_61143_((Property)LEFT) == state.m_61143_((Property)LEFT);
        boolean bl = shape_below_same = below.m_60734_() == state.m_60734_() && below.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && below.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN) && below.m_61143_((Property)LEFT) == state.m_61143_((Property)LEFT);
        if (shape_above_same && !shape_below_same) {
            return ShutterType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return ShutterType.TOP;
        }
        if (shape_above_same) {
            return ShutterType.MIDDLE;
        }
        return ShutterType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, OPEN, LEFT, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

