/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client;

import de.cristelknight.doapi.terraform.sign.TerraformSignHelper;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfyu.meadow.client.render.BigFlowerPotBlockEntityRenderer;
import net.satisfyu.meadow.client.render.CheeseRackBlockEntityRenderer;
import net.satisfyu.meadow.client.render.FlowerBoxBlockEntityRenderer;
import net.satisfyu.meadow.client.render.WheelBarrowBlockEntityRenderer;
import net.satisfyu.meadow.client.screen.CheeseFormGui;
import net.satisfyu.meadow.client.screen.CookingCauldronGui;
import net.satisfyu.meadow.client.screen.FondueGui;
import net.satisfyu.meadow.client.screen.WoodcutterGui;
import net.satisfyu.meadow.entity.bear.BrownBearModel;
import net.satisfyu.meadow.entity.bear.BrownBearRenderer;
import net.satisfyu.meadow.entity.buffalo.WaterBuffaloModel;
import net.satisfyu.meadow.entity.buffalo.WaterBuffaloRenderer;
import net.satisfyu.meadow.entity.cow.shearable.ShearableVarCowRenderer;
import net.satisfyu.meadow.entity.cow.shearable.WoolyCowModel;
import net.satisfyu.meadow.item.FurBoots;
import net.satisfyu.meadow.item.FurChest;
import net.satisfyu.meadow.item.FurHead;
import net.satisfyu.meadow.item.FurLegs;
import net.satisfyu.meadow.registry.ArmorRegistry;
import net.satisfyu.meadow.registry.BlockEntityRegistry;
import net.satisfyu.meadow.registry.EntityRegistry;
import net.satisfyu.meadow.registry.MeadowWoodRegistry;
import net.satisfyu.meadow.registry.ObjectRegistry;
import net.satisfyu.meadow.registry.ScreenHandlerRegistry;
import org.jetbrains.annotations.NotNull;

public class MeadowClient {
    public static final ModelLayerLocation BROWN_BEAR_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "brown_bear"), "main");
    public static final ModelLayerLocation SHEARABLE_MEADOW_COW_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "shearable_meadow_cow"), "head");
    public static final ModelLayerLocation WATER_BUFFALO_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "water_buffalo"), "head");

    public static void preInitClient() {
        MeadowClient.registerEntityRenderers();
        MeadowClient.registerEntityModelLayers();
        TerraformSignHelper.regsterSignSprite((ResourceLocation)MeadowWoodRegistry.PINE_SIGN_TEXTURE);
        TerraformSignHelper.regsterSignSprite((ResourceLocation)MeadowWoodRegistry.PINE_HANGING_SIGN_TEXTURE);
    }

    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.WOODCUTTER.get(), (Block)ObjectRegistry.PINE_DOOR.get(), (Block)ObjectRegistry.PINE_TRAPDOOR.get(), (Block)ObjectRegistry.DELPHINIUM.get(), (Block)ObjectRegistry.ALPINE_POPPY.get(), (Block)ObjectRegistry.SAXIFRAGE.get(), (Block)ObjectRegistry.ENZIAN.get(), (Block)ObjectRegistry.COOKING_CAULDRON.get(), (Block)ObjectRegistry.FRAME.get(), (Block)ObjectRegistry.TABLE.get(), (Block)ObjectRegistry.FIRE_LOG.get(), (Block)ObjectRegistry.ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.SMALL_FIR.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.CHAIR.get(), (Block)ObjectRegistry.POTTED_DELPHINIUM.get(), (Block)ObjectRegistry.POTTED_ALPINE_POPPY.get(), (Block)ObjectRegistry.POTTED_SAXIFRAGE.get(), (Block)ObjectRegistry.POTTED_ENZIAN.get(), (Block)ObjectRegistry.POTTED_ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.POTTED_PINE_SAPLING.get(), (Block)ObjectRegistry.FIRE_LILY.get(), (Block)ObjectRegistry.POTTED_FIRE_LILY.get(), (Block)ObjectRegistry.POTTED_OAK_SAPLING.get(), (Block)ObjectRegistry.POTTED_SPRUCE_SAPLING.get(), (Block)ObjectRegistry.POTTED_BIRCH_SAPLING.get(), (Block)ObjectRegistry.POTTED_JUNGLE_SAPLING.get(), (Block)ObjectRegistry.POTTED_ACACIA_SAPLING.get(), (Block)ObjectRegistry.POTTED_DARK_OAK_SAPLING.get(), (Block)ObjectRegistry.POTTED_DANDELION.get(), (Block)ObjectRegistry.POTTED_POPPY.get(), (Block)ObjectRegistry.POTTED_BLUE_ORCHID.get(), (Block)ObjectRegistry.POTTED_ALLIUM.get(), (Block)ObjectRegistry.POTTED_AZURE_BLUET.get(), (Block)ObjectRegistry.POTTED_RED_TULIP.get(), (Block)ObjectRegistry.POTTED_ORANGE_TULIP.get(), (Block)ObjectRegistry.POTTED_WHITE_TULIP.get(), (Block)ObjectRegistry.POTTED_PINK_TULIP.get(), (Block)ObjectRegistry.POTTED_OXEYE_DAISY.get(), (Block)ObjectRegistry.POTTED_CORNFLOWER.get(), (Block)ObjectRegistry.POTTED_LILY_OF_THE_VALLEY.get(), (Block)ObjectRegistry.POTTED_WITHER_ROSE.get(), (Block)ObjectRegistry.W_POTTED_PINE_SAPLING.get(), (Block)ObjectRegistry.W_POTTED_DELPHINIUM.get(), (Block)ObjectRegistry.W_POTTED_ALPINE_POPPY.get(), (Block)ObjectRegistry.W_POTTED_SAXIFRAGE.get(), (Block)ObjectRegistry.W_POTTED_ENZIAN.get(), (Block)ObjectRegistry.W_POTTED_FIRE_LILY.get(), (Block)ObjectRegistry.W_POTTED_ERIOPHORUM.get(), (Block)ObjectRegistry.POTTED_AZALEA.get(), (Block)ObjectRegistry.POTTED_FLOWERING_AZALEA.get(), (Block)ObjectRegistry.FLOWER_POT_BIG.get(), (Block)ObjectRegistry.FONDUE.get(), (Block)ObjectRegistry.OIL_LANTERN.get(), (Block)ObjectRegistry.WHEELBARROW.get(), (Block)ObjectRegistry.POTTED_MANGROVE_PROPAGULE.get(), (Block)ObjectRegistry.PINE_LEAVES_2.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ObjectRegistry.WINDOW.get(), (Block)ObjectRegistry.WINDOW_2.get(), (Block)ObjectRegistry.WINDOW_3.get()});
        MeadowClient.registerBlockRenderer();
        MeadowClient.registerClientScreens();
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_WATER_CAULDRON});
    }

    private static void registerBlockRenderer() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.FLOWER_BOX_BLOCK_ENTITY.get()), FlowerBoxBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.WHEEL_BARROW_BLOCK_ENTITY.get()), WheelBarrowBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.BIG_FLOWER_POT_BLOCK_ENTITY.get()), BigFlowerPotBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.CHEESE_RACK_BLOCK_ENTITY.get()), CheeseRackBlockEntityRenderer::new);
    }

    private static void registerClientScreens() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get()), CheeseFormGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get()), WoodcutterGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get()), CookingCauldronGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.FONDUE_SCREEN_HANDLER.get()), FondueGui::new);
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityRegistry.BROWN_BEAR, BrownBearRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.SHEARABLE_MEADOW_VAR_COW, ShearableVarCowRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.WATER_BUFFALO, WaterBuffaloRenderer::new);
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)BROWN_BEAR_MODEL_LAYER, BrownBearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SHEARABLE_MEADOW_COW_MODEL_LAYER, WoolyCowModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WATER_BUFFALO_MODEL_LAYER, WaterBuffaloModel::getTexturedModelData);
        ArmorRegistry.registerArmorModelLayers();
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.DARK_GREEN + I18n.m_118938_((String)"meadow.tooltip.fur_armor", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet != null && helmet.m_41720_() instanceof FurHead ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_HELMET.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplate != null && chestplate.m_41720_() instanceof FurChest ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_CHESTPLATE.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggings != null && leggings.m_41720_() instanceof FurLegs ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_LEGGINGS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((boots != null && boots.m_41720_() instanceof FurBoots ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"meadow.tooltip.fur_armor2", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet != null && helmet.m_41720_() instanceof FurHead && chestplate != null && chestplate.m_41720_() instanceof FurChest && leggings != null && leggings.m_41720_() instanceof FurLegs && boots != null && boots.m_41720_() instanceof FurBoots ? ChatFormatting.DARK_GREEN.toString() : ChatFormatting.GRAY.toString()) + I18n.m_118938_((String)"meadow.tooltip.fur_armor3", (Object[])new Object[0]))));
    }
}

