/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfyu.meadow.client.screen.FondueGui;
import net.satisfyu.meadow.compat.jei.MeadowJEIPlugin;
import net.satisfyu.meadow.recipes.fondue.FondueRecipe;
import net.satisfyu.meadow.registry.ObjectRegistry;

public class FondueCategory
implements IRecipeCategory<FondueRecipe> {
    public static final RecipeType<FondueRecipe> FONDUE = RecipeType.create((String)"meadow", (String)"fondue", FondueRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 65;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 6;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public FondueCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(FondueGui.BACKGROUND, 26, 6, 124, 65);
        this.arrow = helper.drawableBuilder(FondueGui.BACKGROUND, 176, 17, 15, 14).buildAnimated(72, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.FONDUE.get()).m_5456_().m_7968_());
        this.localizedName = Component.m_237115_((String)"rei.meadow.fondue_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FondueRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        MeadowJEIPlugin.addSlot(builder, 15, 3, (Ingredient)ingredients.get(0));
        MeadowJEIPlugin.addSlot(builder, 15, 27, (Ingredient)ingredients.get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 19).addItemStack(recipe.getResultItem());
    }

    public void draw(FondueRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 61, 19);
        this.drawAmount(guiGraphics);
    }

    protected void drawAmount(GuiGraphics guiGraphics) {
        MutableComponent amountString = Component.m_237110_((String)"rei.meadow.fondue_category.amount", (Object[])new Object[]{10});
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int stringWidth = fontRenderer.m_92852_((FormattedText)amountString);
        guiGraphics.m_280614_(fontRenderer, (Component)amountString, this.getWidth() - stringWidth, 59, -8355712, false);
    }

    public RecipeType<FondueRecipe> getRecipeType() {
        return FONDUE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

