/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfyu.meadow.client.screen.handler.FondueGuiHandler;
import net.satisfyu.meadow.recipes.fondue.FondueRecipe;
import net.satisfyu.meadow.registry.BlockEntityRegistry;
import net.satisfyu.meadow.registry.RecipeRegistry;
import net.satisfyu.meadow.util.ImplementedInventory;
import org.jetbrains.annotations.Nullable;

public class FondueBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
BlockEntityTicker<FondueBlockEntity> {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS_FOR_SIDE = new int[]{1};
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return FondueBlockEntity.this.progress;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                FondueBlockEntity.this.progress = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int progress = 0;
    public static final int MAX_PROGRESS = 72;
    private int fuelAmount = 0;

    public FondueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.FONDUE.get(), pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public Component m_5446_() {
        return Component.m_130674_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new FondueGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("fondue.progress", this.progress);
        nbt.m_128405_("fondue.fuelAmount", this.fuelAmount);
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress = nbt.m_128451_("fondue.progress");
        this.fuelAmount = nbt.m_128451_("fondue.fuelAmount");
        super.m_142466_(nbt);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public void tick(Level world, BlockPos blockPos, BlockState state, FondueBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        Recipe r = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.FONDUE.get(), (Container)this, world).orElse(null);
        if (!(r instanceof FondueRecipe)) {
            entity.resetProgress();
            FondueBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
            return;
        }
        FondueRecipe recipe = (FondueRecipe)r;
        if (FondueBlockEntity.hasFuel(entity, recipe) && FondueBlockEntity.hasRecipe(entity, recipe)) {
            ++entity.progress;
            FondueBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
            if (entity.progress >= 72) {
                FondueBlockEntity.craftItem(entity, recipe);
            }
        } else {
            entity.resetProgress();
            FondueBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static boolean hasFuel(FondueBlockEntity entity, FondueRecipe recipe) {
        if (entity.fuelAmount > 0) {
            return true;
        }
        ItemStack stack = entity.m_8020_(1);
        if (recipe.getFuel().test(stack)) {
            entity.fuelAmount = 10;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    private static void craftItem(FondueBlockEntity entity, FondueRecipe recipe) {
        entity.m_7407_(0, 1);
        ItemStack stack = recipe.assemble();
        stack.m_41764_(entity.m_8020_(2).m_41613_() + 1);
        entity.m_6836_(2, stack);
        entity.resetProgress();
        --entity.fuelAmount;
    }

    private static boolean hasRecipe(FondueBlockEntity entity, FondueRecipe recipe) {
        ItemStack result = recipe.getResultItem();
        boolean hasBreadInFirstSlot = recipe.getBread().test(entity.m_8020_(0));
        boolean r2 = FondueBlockEntity.canInsertAmountIntoOutputSlot(entity.inventory, result.m_41613_());
        boolean r3 = FondueBlockEntity.canInsertItemIntoOutputSlot(entity.inventory, result.m_41720_());
        return hasBreadInFirstSlot && r2 && r3;
    }

    private static boolean canInsertItemIntoOutputSlot(NonNullList<ItemStack> inventory, Item output) {
        return ((ItemStack)inventory.get(2)).m_41720_() == output || ((ItemStack)inventory.get(2)).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(NonNullList<ItemStack> inventory, int additionalAmount) {
        return ((ItemStack)inventory.get(2)).m_41741_() >= ((ItemStack)inventory.get(2)).m_41613_() + additionalAmount;
    }
}

