/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.chicken;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.satisfyu.meadow.registry.TagRegistry;
import net.satisfyu.meadow.world.CommonSpawnUtil;
import org.jetbrains.annotations.NotNull;

public enum ChickenVar implements StringRepresentable
{
    DEFAULT(0, "chicken"),
    CHICKEN_1(1, "chicken_1"),
    CHICKEN_2(2, "chicken_2"),
    CHICKEN_3(3, "chicken_3");

    public static final Codec<ChickenVar> CODEC;
    private static final IntFunction<ChickenVar> BY_ID;
    private final int id;
    private final String name;
    public static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT;
    private static final Map<ChickenVar, TagKey<Biome>> SPAWNS;

    private ChickenVar(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public static ChickenVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static void setVariant(Chicken Chicken2, ChickenVar variant) {
        ChickenVar.setTypeVariant(Chicken2, variant.getId() & 0xFF | ChickenVar.getTypeVariant(Chicken2) & 0xFFFFFF00);
    }

    public static ChickenVar getVariant(Chicken Chicken2) {
        return ChickenVar.byId(ChickenVar.getTypeVariant(Chicken2) & 0xFF);
    }

    public static void setTypeVariant(Chicken Chicken2, int i) {
        Chicken2.m_20088_().m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    public static int getTypeVariant(Chicken Chicken2) {
        return (Integer)Chicken2.m_20088_().m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public static ChickenVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        List<ChickenVar> possibleVars = ChickenVar.getChickenVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        RandomSource random = levelAccessor.m_213780_();
        if (size == 0 || spawnEgg) {
            return (ChickenVar)((Object)Util.m_214670_((Object[])ChickenVar.values(), (RandomSource)random));
        }
        return possibleVars.get(random.m_188503_(size));
    }

    private static List<ChickenVar> getChickenVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(ChickenVariant -> {
            TagKey<Biome> biomeTag = SPAWNS.get(ChickenVariant);
            if (biomeTag == null) {
                return CommonSpawnUtil.spawnsInBiome(biome, true, EntityType.f_20555_);
            }
            return biome.m_203656_(biomeTag);
        }).collect(Collectors.toList());
    }

    static {
        CODEC = StringRepresentable.m_216439_(ChickenVar::values);
        BY_ID = ByIdMap.m_262839_(ChickenVar::getId, (Object[])ChickenVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Chicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(DEFAULT, null);
            map.put(CHICKEN_1, TagRegistry.IS_MEADOW);
            map.put(CHICKEN_2, TagRegistry.IS_MEADOW);
            map.put(CHICKEN_3, TagRegistry.IS_MEADOW);
        });
    }
}

