/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.cow;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.satisfyu.meadow.registry.TagRegistry;
import net.satisfyu.meadow.world.CommonSpawnUtil;
import org.jetbrains.annotations.NotNull;

public enum CowVar implements StringRepresentable
{
    DEFAULT(0, "cow"),
    ALBINO(1, "albino"),
    COOKIE(2, "cookie"),
    CREAM(3, "cream"),
    DAIRY(4, "dairy"),
    DARK(5, "dark"),
    PINTO(6, "pinto"),
    SUNSET(7, "sunset");

    public static final Codec<CowVar> CODEC;
    private static final IntFunction<CowVar> BY_ID;
    private final int id;
    private final String name;
    public static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT;
    private static final Map<CowVar, TagKey<Biome>> SPAWNS;

    private CowVar(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public static CowVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static void setVariant(Cow cow, CowVar variant) {
        CowVar.setTypeVariant(cow, variant.getId() & 0xFF | CowVar.getTypeVariant(cow) & 0xFFFFFF00);
    }

    public static CowVar getVariant(Cow cow) {
        return CowVar.byId(CowVar.getTypeVariant(cow) & 0xFF);
    }

    public static void setTypeVariant(Cow cow, int i) {
        cow.m_20088_().m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    public static int getTypeVariant(Cow cow) {
        return (Integer)cow.m_20088_().m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public static CowVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        List<CowVar> possibleVars = CowVar.getCowVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        RandomSource random = levelAccessor.m_213780_();
        if (size == 0 || spawnEgg) {
            return (CowVar)((Object)Util.m_214670_((Object[])CowVar.values(), (RandomSource)random));
        }
        return possibleVars.get(random.m_188503_(size));
    }

    private static List<CowVar> getCowVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(cowVariant -> {
            TagKey<Biome> biomeTag = SPAWNS.get(cowVariant);
            if (biomeTag == null) {
                return CommonSpawnUtil.spawnsInBiome(biome, true, EntityType.f_20557_);
            }
            return biome.m_203656_(biomeTag);
        }).collect(Collectors.toList());
    }

    static {
        CODEC = StringRepresentable.m_216439_(CowVar::values);
        BY_ID = ByIdMap.m_262839_(CowVar::getId, (Object[])CowVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Cow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(DEFAULT, null);
            map.put(COOKIE, TagRegistry.IS_MEADOW);
            map.put(DAIRY, TagRegistry.IS_MEADOW);
            map.put(CREAM, null);
            map.put(PINTO, null);
            map.put(DARK, TagRegistry.SPAWNS_DARK_COW);
            map.put(ALBINO, TagRegistry.SPAWNS_BEAR);
            map.put(SUNSET, TagRegistry.SPAWNS_SUNSET_COW);
        });
    }
}

