/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.cow.shearable;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.satisfyu.meadow.registry.ObjectRegistry;
import net.satisfyu.meadow.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum ShearableCowVar implements StringRepresentable
{
    HIGHLAND(0, "highland_cattle", ((Block)ObjectRegistry.HIGHLAND_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_BUFFALO_MILK_BUCKET.get()),
    UMBRA(1, "umbra_cow", ((Block)ObjectRegistry.UMBRA_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_BUFFALO_MILK_BUCKET.get()),
    WARPED(2, "warped_cow", ((Block)ObjectRegistry.WARPED_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_WARPED_MILK_BUCKET.get());

    public static final Codec<ShearableCowVar> CODEC;
    private static final IntFunction<ShearableCowVar> BY_ID;
    private final int id;
    private final String name;
    private final Item wool;
    private final Item bucket;
    private static final Map<ShearableCowVar, TagKey<Biome>> SPAWNS;

    private ShearableCowVar(int id, String name, Item wool, Item bucket) {
        this.id = id;
        this.name = name;
        this.wool = wool;
        this.bucket = bucket;
    }

    public Item getWool() {
        return this.wool;
    }

    public Item getBucket() {
        return this.bucket;
    }

    public int getId() {
        return this.id;
    }

    public static ShearableCowVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static ShearableCowVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        RandomSource random = levelAccessor.m_213780_();
        List<ShearableCowVar> possibleVars = ShearableCowVar.getShearableCowVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (ShearableCowVar)((Object)Util.m_214670_((Object[])ShearableCowVar.values(), (RandomSource)random));
            }
            if (holder.m_203656_(BiomeTags.f_207612_)) {
                return WARPED;
            }
            ArrayList<ShearableCowVar> list = new ArrayList<ShearableCowVar>(List.of(ShearableCowVar.values()));
            list.remove((Object)WARPED);
            return (ShearableCowVar)((Object)Util.m_214621_(list, (RandomSource)random));
        }
        return possibleVars.get(levelAccessor.m_213780_().m_188503_(size));
    }

    private static List<ShearableCowVar> getShearableCowVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(ShearableCowVariant -> biome.m_203656_(SPAWNS.get(ShearableCowVariant))).collect(Collectors.toList());
    }

    static {
        CODEC = StringRepresentable.m_216439_(ShearableCowVar::values);
        BY_ID = ByIdMap.m_262839_(ShearableCowVar::getId, (Object[])ShearableCowVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(HIGHLAND, TagRegistry.IS_MEADOW);
            map.put(UMBRA, TagRegistry.SPAWNS_DARK_COW);
            map.put(WARPED, TagRegistry.SPAWNS_WARPED_COW);
        });
    }
}

