/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.mixin.variant;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.satisfyu.meadow.entity.chicken.ChickenVar;
import net.satisfyu.meadow.mixin.variant.MobVariantMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chicken.class})
public abstract class ChickenVariantMixin
extends MobVariantMixin {
    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        ChickenVar.setVariant(this.getChicken(), ChickenVar.getRandomVariant((LevelAccessor)serverLevelAccessor, this.getChicken().m_20183_(), mobSpawnType.equals((Object)MobSpawnType.SPAWN_EGG)));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Chicken;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onGetBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob, CallbackInfoReturnable<Chicken> cir) {
        Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_((Level)serverLevel);
        if (chicken == null) {
            return;
        }
        RandomSource random = serverLevel.m_213780_();
        ChickenVar var = ChickenVar.getVariant(this.getChicken());
        if (random.m_188499_() && ageableMob instanceof Chicken) {
            Chicken varChicken = (Chicken)ageableMob;
            var = ChickenVar.getVariant(varChicken);
        }
        ChickenVar.setVariant(chicken, var);
        cir.setReturnValue((Object)chicken);
    }

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        this.getChicken().m_20088_().m_135372_(ChickenVar.DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128405_("Variant", ChickenVar.getTypeVariant(this.getChicken()));
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        ChickenVar.setTypeVariant(this.getChicken(), compoundTag.m_128451_("Variant"));
    }

    @Unique
    private Chicken getChicken() {
        return (Chicken)this;
    }
}

