/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.mixin.variant;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.satisfyu.meadow.entity.cow.CowVar;
import net.satisfyu.meadow.mixin.variant.MobVariantMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cow.class})
public abstract class CowVariantMixin
extends MobVariantMixin {
    @Override
    protected void onTick(CallbackInfo ci) {
        if (CowVar.getVariant(this.getCow()).equals((Object)CowVar.ALBINO) && !this.getCow().m_6162_() && this.getCow().m_9236_().m_46461_() && this.getCow().m_9236_().m_45527_(this.getCow().m_20183_())) {
            this.getCow().m_6469_(this.getCow().m_9236_().m_269111_().m_269387_(), 0.5f);
        }
    }

    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        CowVar.setVariant(this.getCow(), CowVar.getRandomVariant((LevelAccessor)serverLevelAccessor, this.getCow().m_20183_(), mobSpawnType.equals((Object)MobSpawnType.SPAWN_EGG)));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Cow;"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onGetBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob, CallbackInfoReturnable<Cow> cir) {
        Cow cow = (Cow)EntityType.f_20557_.m_20615_((Level)serverLevel);
        if (cow == null) {
            return;
        }
        RandomSource random = serverLevel.m_213780_();
        CowVar var = CowVar.getVariant(this.getCow());
        if (random.m_188499_() && ageableMob instanceof Cow) {
            Cow varCow = (Cow)ageableMob;
            var = CowVar.getVariant(varCow);
        }
        CowVar.setVariant(cow, var);
        cir.setReturnValue((Object)cow);
    }

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        this.getCow().m_20088_().m_135372_(CowVar.DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128405_("Variant", CowVar.getTypeVariant(this.getCow()));
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        CowVar.setTypeVariant(this.getCow(), compoundTag.m_128451_("Variant"));
    }

    @Unique
    private Cow getCow() {
        return (Cow)this;
    }
}

