/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.mixin.variant;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.satisfyu.meadow.entity.sheep.SheepVar;
import net.satisfyu.meadow.mixin.variant.MobVariantMixin;
import net.satisfyu.meadow.util.MeadowIdentifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheep.class})
public abstract class SheepVariantMixin
extends MobVariantMixin {
    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        SheepVar.setVariant(this.getSheep(), SheepVar.getRandomVariant((LevelAccessor)serverLevelAccessor, this.getSheep().m_20183_(), mobSpawnType.equals((Object)MobSpawnType.SPAWN_EGG)));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Sheep;"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob, CallbackInfoReturnable<Sheep> cir) {
        Sheep sheep = (Sheep)EntityType.f_20520_.m_20615_((Level)serverLevel);
        if (sheep == null) {
            return;
        }
        RandomSource random = serverLevel.m_213780_();
        SheepVar var = SheepVar.getVariant(this.getSheep());
        if (random.m_188499_() && ageableMob instanceof Sheep) {
            Sheep varSheep = (Sheep)ageableMob;
            var = SheepVar.getVariant(varSheep);
        }
        SheepVar.setVariant(sheep, var);
        cir.setReturnValue((Object)sheep);
    }

    @ModifyArg(method={"shear"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Sheep;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;I)Lnet/minecraft/world/entity/item/ItemEntity;"))
    public ItemLike getDrop(ItemLike itemLike) {
        if (itemLike.m_5456_().equals(Items.f_41870_)) {
            return SheepVar.getVariant(this.getSheep()).getWool();
        }
        return itemLike;
    }

    @Inject(method={"getDefaultLootTable"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDefaultLootTable(CallbackInfoReturnable<ResourceLocation> cir) {
        Sheep sheep = this.getSheep();
        SheepVar var = SheepVar.getVariant(sheep);
        Item wool = var.getWool();
        if (sheep.m_29875_() || wool.equals(Items.f_41870_) || !sheep.m_29874_().equals((Object)DyeColor.WHITE)) {
            return;
        }
        ResourceLocation location = BuiltInRegistries.f_257033_.m_7981_((Object)wool);
        String s = location.m_135815_().replace("_wool", "");
        cir.setReturnValue((Object)new MeadowIdentifier("entities/sheep/" + s));
    }

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        this.getSheep().m_20088_().m_135372_(SheepVar.DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128405_("Variant", SheepVar.getTypeVariant(this.getSheep()));
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        SheepVar.setTypeVariant(this.getSheep(), compoundTag.m_128451_("Variant"));
    }

    @Unique
    private Sheep getSheep() {
        return (Sheep)this;
    }
}

